/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.inspectors.auth;

import com.eviware.soapui.config.AccessTokenStatusConfig;
import com.eviware.soapui.support.MessageSupport;
import com.eviware.soapui.support.editor.inspectors.auth.OAuth1TokenStatusChangeListener;
import com.google.common.base.Preconditions;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class OAuth1TokenStatusChangeManager
implements PropertyChangeListener {
    private static final MessageSupport messages = MessageSupport.getMessages(OAuth1TokenStatusChangeManager.class);
    OAuth1TokenStatusChangeListener listener = null;

    public OAuth1TokenStatusChangeManager(OAuth1TokenStatusChangeListener listener) {
        this.listener = listener;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("accessTokenStatus")) {
            AccessTokenStatusConfig.Enum status = (AccessTokenStatusConfig.Enum)((Object)evt.getNewValue());
            this.listener.onAccessTokenStatusChanged(status);
        } else if (evt.getPropertyName().equals("tokenSecretStatus")) {
            AccessTokenStatusConfig.Enum status = (AccessTokenStatusConfig.Enum)((Object)evt.getNewValue());
            this.listener.onTokenSecretStatusChanged(status);
        }
    }

    public void register() {
        Preconditions.checkNotNull((Object)this.listener.getProfile(), (Object)messages.get("OAuth1TokenStatusChangeManager.Error.MissingProfile"));
        this.listener.getProfile().addPropertyChangeListener(this);
    }

    public void unregister() {
        Preconditions.checkNotNull((Object)this.listener.getProfile(), (Object)messages.get("OAuth1TokenStatusChangeManager.Error.MissingProfile"));
        this.listener.getProfile().removePropertyChangeListener(this);
    }
}

