/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.inspectors.auth;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.OAuth2FlowConfig;
import com.eviware.soapui.impl.rest.OAuth2Profile;
import com.eviware.soapui.impl.rest.actions.oauth.GetOAuthAccessTokenAction;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.PropertyComponent;
import com.eviware.soapui.support.components.SimpleBindingForm;
import com.eviware.soapui.support.editor.inspectors.auth.OAuth2AccessTokenStatusChangeListener;
import com.eviware.soapui.support.editor.inspectors.auth.OAuth2AccessTokenStatusChangeManager;
import com.eviware.soapui.support.editor.inspectors.auth.OAuth2Form;
import com.eviware.soapui.support.editor.inspectors.auth.OAuth2ScriptsDesktopPanel;
import com.jgoodies.binding.PresentationModel;
import com.jgoodies.binding.value.AbstractValueModel;
import com.jgoodies.binding.value.ValueModel;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class OAuth2GetAccessTokenForm
implements OAuth2AccessTokenStatusChangeListener {
    public static final String CLIENT_ID_TITLE = "Client Identification";
    public static final String CLIENT_SECRET_TITLE = "Client Secret";
    public static final String RESOURCE_OWNER_LOGIN = "Resource Owner Name";
    public static final String RESOURCE_OWNER_PASSWORD = "Resource Owner Password";
    public static final String AUTHORIZATION_URI_TITLE = "Authorization URI";
    public static final String ACCESS_TOKEN_URI_TITLE = "Access Token URI";
    public static final String REDIRECT_URI_TITLE = "Redirect URI";
    public static final String SCOPE_TITLE = "Scope";
    public static final String OAUTH_2_FLOW_COMBO_BOX_NAME = "OAuth2Flow";
    public static final String ACCESS_TOKEN_FORM_DIALOG_NAME = "getAccessTokenFormDialog";
    private static final String GET_ACCESS_TOKEN_BUTTON_NAME = "getAccessTokenButtonName";
    private static final String ACCESS_TOKEN_FORM_DIALOG_TITLE = "Get Access Token";
    private static final String AUTOMATION_BUTTON_TITLE = "Automation...";
    private static final String GET_ACCESS_TOKEN_FORM_LAYOUT = "7dlu:none,left:pref,10dlu,left:pref,10dlu,left:MAX(112dlu;pref),7dlu";
    private static final int BOARDER_SPACING = 15;
    private static final int NORMAL_SPACING = 10;
    private static final int GROUP_SPACING = 20;
    private static final Color CARD_BORDER_COLOR = new Color(121, 121, 121);
    static final ImageIcon DEFAULT_ICON = null;
    private OAuth2Profile profile;
    private JLabel accessTokenStatusText;
    private OAuth2AccessTokenStatusChangeManager statusChangeManager;
    private JDialog accessTokenDialog;
    private OAuth2ScriptsDesktopPanel scriptEditorPanel;

    public OAuth2GetAccessTokenForm(OAuth2Profile profile) {
        this.profile = profile;
    }

    public JDialog getComponent() {
        SimpleBindingForm accessTokenForm = this.createSimpleBindingForm(this.profile);
        this.statusChangeManager = new OAuth2AccessTokenStatusChangeManager(this);
        this.populateGetAccessTokenForm(accessTokenForm);
        this.statusChangeManager.register();
        if (this.profile.getAccessTokenStatus() != OAuth2Profile.AccessTokenStatus.RETRIEVAL_CANCELED) {
            this.profile.resetAccessTokenStatusToStartingStatus();
        }
        this.setOAuth2StatusFeedback(this.profile.getAccessTokenStatus());
        this.accessTokenDialog = this.createGetAccessTokenDialog(accessTokenForm.getPanel());
        return this.accessTokenDialog;
    }

    @Override
    public void onAccessTokenStatusChanged(@Nonnull OAuth2Profile.AccessTokenStatus status) {
        this.setOAuth2StatusFeedback(status);
    }

    @Override
    @Nonnull
    public OAuth2Profile getProfile() {
        return this.profile;
    }

    void release() {
        this.statusChangeManager.unregister();
    }

    private SimpleBindingForm createSimpleBindingForm(OAuth2Profile profile) {
        PresentationModel presentationModel = new PresentationModel((Object)profile);
        String columnsSpecs = GET_ACCESS_TOKEN_FORM_LAYOUT;
        Border border = BorderFactory.createLineBorder(CARD_BORDER_COLOR, 1);
        return new SimpleBindingForm(presentationModel, columnsSpecs, border);
    }

    private void populateGetAccessTokenForm(SimpleBindingForm accessTokenForm) {
        accessTokenForm.addSpace(15);
        accessTokenForm.appendHeadingAndHelpButton("Get Access Token from the authorization server", "/OAuth/access-token-retrieval.html");
        accessTokenForm.addSpace(10);
        JComboBox oauth2FlowComboBox = this.appendOAuth2ComboBox(accessTokenForm);
        accessTokenForm.addSpace(20);
        final JTextField resOwnerPassTextField = accessTokenForm.appendTextField("resourceOwnerName", RESOURCE_OWNER_LOGIN, "");
        resOwnerPassTextField.setVisible(oauth2FlowComboBox.getSelectedItem().equals((Object)OAuth2Profile.OAuth2Flow.valueOf(OAuth2FlowConfig.RESOURCE_OWNER_PASSWORD_CREDENTIALS.toString())));
        final JTextField resOwnerNameTextField = accessTokenForm.appendTextField("resourceOwnerPassword", RESOURCE_OWNER_PASSWORD, "");
        resOwnerNameTextField.setVisible(oauth2FlowComboBox.getSelectedItem().equals((Object)OAuth2Profile.OAuth2Flow.valueOf(OAuth2FlowConfig.RESOURCE_OWNER_PASSWORD_CREDENTIALS.toString())));
        accessTokenForm.appendTextField("clientID", CLIENT_ID_TITLE, "");
        final JTextField clientSecretField = this.appendClientSecretField(accessTokenForm, this.getOAuth2FlowValueModel(accessTokenForm));
        accessTokenForm.addSpace(20);
        final JTextField authUriTextField = accessTokenForm.appendTextField("authorizationURI", AUTHORIZATION_URI_TITLE, "");
        authUriTextField.setVisible(!oauth2FlowComboBox.getSelectedItem().equals((Object)OAuth2Profile.OAuth2Flow.valueOf(OAuth2FlowConfig.RESOURCE_OWNER_PASSWORD_CREDENTIALS.toString())) && !oauth2FlowComboBox.getSelectedItem().equals((Object)OAuth2Profile.OAuth2Flow.valueOf(OAuth2FlowConfig.CLIENT_CREDENTIALS_GRANT.toString())));
        final JTextField accessTokenUriField = this.appendAccessTokenUriField(accessTokenForm, this.getOAuth2FlowValueModel(accessTokenForm));
        final JTextField redirectUriTextField = accessTokenForm.appendTextField("redirectURI", REDIRECT_URI_TITLE, "");
        redirectUriTextField.setVisible(!oauth2FlowComboBox.getSelectedItem().equals((Object)OAuth2Profile.OAuth2Flow.valueOf(OAuth2FlowConfig.RESOURCE_OWNER_PASSWORD_CREDENTIALS.toString())) && !oauth2FlowComboBox.getSelectedItem().equals((Object)OAuth2Profile.OAuth2Flow.valueOf(OAuth2FlowConfig.CLIENT_CREDENTIALS_GRANT.toString())));
        accessTokenForm.addSpace(20);
        accessTokenForm.appendTextField("scope", SCOPE_TITLE, "");
        accessTokenForm.addSpace(10);
        accessTokenForm.appendComponentsInOneRow(this.createGetAccessTokenButton(), this.createAccessTokenStatusText());
        accessTokenForm.appendButtonWithoutLabel(AUTOMATION_BUTTON_TITLE, new EditAutomationScriptsAction(this.profile));
        accessTokenForm.addSpace(20);
        accessTokenForm.appendLabelAsLink("/OAuth/access-token-from-server.html", "How to get an access token from an authorization server");
        accessTokenForm.addSpace(15);
        oauth2FlowComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    clientSecretField.setVisible(!e.getItem().equals((Object)OAuth2Profile.OAuth2Flow.valueOf(OAuth2FlowConfig.IMPLICIT_GRANT.toString())));
                    accessTokenUriField.setVisible(!e.getItem().equals((Object)OAuth2Profile.OAuth2Flow.valueOf(OAuth2FlowConfig.IMPLICIT_GRANT.toString())));
                    authUriTextField.setVisible(!e.getItem().equals((Object)OAuth2Profile.OAuth2Flow.valueOf(OAuth2FlowConfig.RESOURCE_OWNER_PASSWORD_CREDENTIALS.toString())) && !e.getItem().equals((Object)OAuth2Profile.OAuth2Flow.valueOf(OAuth2FlowConfig.CLIENT_CREDENTIALS_GRANT.toString())));
                    redirectUriTextField.setVisible(!e.getItem().equals((Object)OAuth2Profile.OAuth2Flow.valueOf(OAuth2FlowConfig.RESOURCE_OWNER_PASSWORD_CREDENTIALS.toString())) && !e.getItem().equals((Object)OAuth2Profile.OAuth2Flow.valueOf(OAuth2FlowConfig.CLIENT_CREDENTIALS_GRANT.toString())));
                    resOwnerNameTextField.setVisible(e.getItem().equals((Object)OAuth2Profile.OAuth2Flow.valueOf(OAuth2FlowConfig.RESOURCE_OWNER_PASSWORD_CREDENTIALS.toString())));
                    resOwnerPassTextField.setVisible(e.getItem().equals((Object)OAuth2Profile.OAuth2Flow.valueOf(OAuth2FlowConfig.RESOURCE_OWNER_PASSWORD_CREDENTIALS.toString())));
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            OAuth2GetAccessTokenForm.this.accessTokenDialog.pack();
                        }
                    });
                }
            }
        });
    }

    private AbstractValueModel getOAuth2FlowValueModel(SimpleBindingForm accessTokenForm) {
        return accessTokenForm.getPresentationModel().getModel("oAuth2Flow", "getOAuth2Flow", "setOAuth2Flow");
    }

    private JComboBox appendOAuth2ComboBox(SimpleBindingForm accessTokenForm) {
        AbstractValueModel valueModel = this.getOAuth2FlowValueModel(accessTokenForm);
        DefaultComboBoxModel<OAuth2Profile.OAuth2Flow> oauth2FlowsModel = new DefaultComboBoxModel<OAuth2Profile.OAuth2Flow>(OAuth2Profile.OAuth2Flow.values());
        JComboBox oauth2FlowComboBox = accessTokenForm.appendComboBox("OAuth 2 Flow", oauth2FlowsModel, "OAuth 2 Authorization Flow", (ValueModel)valueModel);
        oauth2FlowComboBox.setName(OAUTH_2_FLOW_COMBO_BOX_NAME);
        return oauth2FlowComboBox;
    }

    private JTextField appendClientSecretField(SimpleBindingForm accessTokenForm, AbstractValueModel valueModel) {
        JTextField clientSecretField = accessTokenForm.appendTextField("clientSecret", CLIENT_SECRET_TITLE, "");
        if (valueModel.getValue() == OAuth2Profile.OAuth2Flow.IMPLICIT_GRANT) {
            clientSecretField.setVisible(false);
        }
        return clientSecretField;
    }

    private JTextField appendAccessTokenUriField(SimpleBindingForm accessTokenForm, AbstractValueModel valueModel) {
        JTextField accessTokenUriField = accessTokenForm.appendTextField("accessTokenURI", ACCESS_TOKEN_URI_TITLE, "");
        if (valueModel.getValue() == OAuth2Profile.OAuth2Flow.IMPLICIT_GRANT) {
            accessTokenUriField.setVisible(false);
        }
        return accessTokenUriField;
    }

    private PropertyComponent createGetAccessTokenButton() {
        JButton getAccessTokenButton = new JButton(new GetOAuthAccessTokenAction(this.profile));
        getAccessTokenButton.setName(GET_ACCESS_TOKEN_BUTTON_NAME);
        return new PropertyComponent(getAccessTokenButton);
    }

    private PropertyComponent createAccessTokenStatusText() {
        this.accessTokenStatusText = new JLabel();
        return new PropertyComponent(this.accessTokenStatusText);
    }

    private JDialog createGetAccessTokenDialog(JPanel accessTokenFormPanel) {
        JDialog accessTokenFormDialog = new JDialog();
        accessTokenFormDialog.setName(ACCESS_TOKEN_FORM_DIALOG_NAME);
        accessTokenFormDialog.setTitle(ACCESS_TOKEN_FORM_DIALOG_TITLE);
        accessTokenFormDialog.setIconImages(SoapUI.getFrameIcons());
        accessTokenFormDialog.setUndecorated(true);
        accessTokenFormDialog.getContentPane().add(accessTokenFormPanel);
        return accessTokenFormDialog;
    }

    private void setOAuth2StatusFeedback(OAuth2Profile.AccessTokenStatus status) {
        if (status == null) {
            this.setDefaultFeedback();
        } else {
            switch (status) {
                case WAITING_FOR_AUTHORIZATION: 
                case RECEIVED_AUTHORIZATION_CODE: {
                    this.setWaitingFeedback(status);
                    break;
                }
                case RETRIEVAL_CANCELED: {
                    this.setCanceledFeedback(status);
                    break;
                }
                default: {
                    this.setDefaultFeedback();
                }
            }
        }
    }

    private void setCanceledFeedback(OAuth2Profile.AccessTokenStatus status) {
        this.accessTokenStatusText.setText(status.toString());
        this.accessTokenStatusText.setIcon(OAuth2Form.FAIL_ICON);
    }

    private void setWaitingFeedback(OAuth2Profile.AccessTokenStatus status) {
        this.accessTokenStatusText.setText(status.toString());
        this.accessTokenStatusText.setIcon(OAuth2Form.WAIT_ICON);
    }

    private void setDefaultFeedback() {
        this.accessTokenStatusText.setText("");
        this.accessTokenStatusText.setIcon(DEFAULT_ICON);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OAuth2GetAccessTokenForm.this.closeGetAccessTokenDialog();
            }
        });
    }

    private void closeGetAccessTokenDialog() {
        if (this.accessTokenDialog != null) {
            this.accessTokenDialog.setVisible(false);
            this.accessTokenDialog.dispose();
        }
    }

    private class EditAutomationScriptsAction
    extends AbstractAction {
        private final OAuth2Profile profile;

        public EditAutomationScriptsAction(OAuth2Profile profile) {
            this.putValue("Name", OAuth2GetAccessTokenForm.AUTOMATION_BUTTON_TITLE);
            this.profile = profile;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OAuth2GetAccessTokenForm.this.closeGetAccessTokenDialog();
            if (OAuth2GetAccessTokenForm.this.scriptEditorPanel == null) {
                OAuth2GetAccessTokenForm.this.scriptEditorPanel = new OAuth2ScriptsDesktopPanel(this.profile);
            }
            UISupport.showDesktopPanel(OAuth2GetAccessTokenForm.this.scriptEditorPanel);
        }
    }
}

