/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.factory;

import com.eviware.soapui.DefaultSoapUICore;
import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.SoapUIFactoriesConfig;
import com.eviware.soapui.config.SoapUIFactoryConfig;
import com.eviware.soapui.config.SoapuiFactoriesDocumentConfig;
import com.eviware.soapui.support.factory.InitializableFactory;
import com.eviware.soapui.support.factory.SoapUIFactoryRegistryListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SoapUIFactoryRegistry {
    private Map<Class<?>, List<Object>> factories = new HashMap();
    private Map<Class<?>, SoapUIFactoryConfig> factoryConfigs = new HashMap();
    private static final Logger log = LogManager.getLogger(SoapUIFactoryRegistry.class);
    private Set<SoapUIFactoryRegistryListener> listeners = new HashSet<SoapUIFactoryRegistryListener>();

    public SoapUIFactoryRegistry(InputStream config) {
        if (config != null) {
            this.addConfig(config, this.getClass().getClassLoader());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfig(InputStream config, ClassLoader classLoader) {
        try {
            SoapuiFactoriesDocumentConfig configDocument = SoapuiFactoriesDocumentConfig.Factory.parse(config);
            SoapUIFactoriesConfig soapuiListeners = configDocument.getSoapuiFactories();
            for (SoapUIFactoryConfig factoryConfig : soapuiListeners.getFactoryList()) {
                try {
                    String factoryTypeName = factoryConfig.getFactoryType();
                    String factoryClassName = factoryConfig.getFactoryClass();
                    Class<?> factoryType = Class.forName(factoryTypeName, true, classLoader);
                    Class<?> factoryClass = Class.forName(factoryClassName, true, classLoader);
                    if (!factoryType.isAssignableFrom(factoryClass)) {
                        throw new RuntimeException("Factory class: " + factoryClassName + " must be of type: " + factoryTypeName);
                    }
                    Object obj = factoryClass.newInstance();
                    if (obj instanceof InitializableFactory) {
                        ((InitializableFactory)obj).init(factoryConfig);
                    }
                    this.getLog().info("Adding factory [" + factoryClass + "]");
                    this.addFactory(factoryType, obj);
                }
                catch (Exception e) {
                    System.err.println("Error initializing Listener: " + e);
                }
            }
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
        finally {
            try {
                config.close();
            }
            catch (IOException e) {
                SoapUI.logError(e);
            }
        }
    }

    private Logger getLog() {
        return DefaultSoapUICore.log == null ? log : DefaultSoapUICore.log;
    }

    public void addFactory(Class<?> factoryType, Object factory) {
        if (!this.factories.containsKey(factoryType)) {
            this.factories.put(factoryType, new ArrayList());
        }
        this.factories.get(factoryType).add(factory);
        for (SoapUIFactoryRegistryListener listener : this.listeners) {
            listener.factoryAdded(factoryType, factory);
        }
    }

    public void removeFactory(Class<?> factoryType, Object factory) {
        if (this.factories.containsKey(factoryType)) {
            this.factories.get(factoryType).remove(factory);
            for (SoapUIFactoryRegistryListener listener : this.listeners) {
                listener.factoryRemoved(factoryType, factory);
            }
        }
    }

    public <T> List<T> getFactories(Class<T> factoryType) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.factories.containsKey(factoryType)) {
            for (Object obj : this.factories.get(factoryType)) {
                result.add(obj);
            }
        }
        return result;
    }

    public void addFactoryRegistryListener(SoapUIFactoryRegistryListener listener) {
        this.listeners.add(listener);
    }

    public void removeFactoryRegistryListener(SoapUIFactoryRegistryListener listener) {
        this.listeners.remove(listener);
    }
}

