/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.ui.support;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.HasHelpUrl;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.support.components.ModelItemXmlEditor;
import com.eviware.soapui.impl.support.components.RequestMessageXmlEditor;
import com.eviware.soapui.impl.support.components.ResponseMessageXmlEditor;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.panels.mockoperation.MockRequestXmlDocument;
import com.eviware.soapui.impl.wsdl.panels.mockoperation.MockResponseXmlDocument;
import com.eviware.soapui.impl.wsdl.submit.transports.http.DocumentContent;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.mock.MockRequest;
import com.eviware.soapui.model.mock.MockResponse;
import com.eviware.soapui.model.mock.MockResult;
import com.eviware.soapui.model.mock.MockRunner;
import com.eviware.soapui.settings.UISettings;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.actions.ChangeSplitPaneOrientationAction;
import com.eviware.soapui.support.components.JEditorStatusBarWithProgress;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.editor.EditorDocument;
import com.eviware.soapui.support.editor.views.xml.source.XmlSourceEditorView;
import com.eviware.soapui.support.editor.xml.XmlDocument;
import com.eviware.soapui.support.swing.SoapUISplitPaneUI;
import com.eviware.soapui.ui.support.ModelItemDesktopPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public abstract class AbstractMockResponseDesktopPanel<ModelItemType extends ModelItem, MockResponseType extends MockResponse>
extends ModelItemDesktopPanel<ModelItemType>
implements HasHelpUrl {
    private JEditorStatusBarWithProgress statusBar;
    private JButton splitButton;
    private MockRunner mockRunner;
    private JSplitPane requestSplitPane;
    private MoveFocusAction moveFocusAction;
    private ClosePanelAction closePanelAction = new ClosePanelAction();
    private ModelItemXmlEditor<?, ?> requestEditor;
    private MockResponseMessageEditor responseEditor;
    private JTabbedPane requestTabs;
    private JPanel requestTabPanel;
    private JToggleButton tabsButton;
    public boolean responseHasFocus;
    private InternalPropertyChangeListener propertyChangeListener = new InternalPropertyChangeListener();
    private MockResponseType mockResponse;

    public AbstractMockResponseDesktopPanel(ModelItemType modelItem) {
        super(modelItem);
    }

    protected void init(MockResponseType mockResponse) {
        this.mockResponse = mockResponse;
        this.add((Component)this.buildContent(), "Center");
        this.add((Component)this.buildToolbar(), "North");
        this.add((Component)this.buildStatusLabel(), "South");
        this.setPreferredSize(new Dimension(600, 500));
        mockResponse.addPropertyChangeListener(this.propertyChangeListener);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!AbstractMockResponseDesktopPanel.this.hasRequestEditor() || AbstractMockResponseDesktopPanel.this.requestTabs.getSelectedIndex() == 1 || AbstractMockResponseDesktopPanel.this.responseHasFocus) {
                    AbstractMockResponseDesktopPanel.this.responseEditor.requestFocus();
                } else {
                    AbstractMockResponseDesktopPanel.this.requestEditor.requestFocus();
                }
            }
        });
        try {
            if (mockResponse.getAttachmentCount() > 0) {
                mockResponse.getMockOperation().getOperation().getInterface().getDefinitionContext().loadIfNecessary();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected MockResponseType getMockResponse() {
        return this.mockResponse;
    }

    public final ModelItemXmlEditor<?, ?> getRequestEditor() {
        return this.requestEditor;
    }

    public final MockResponseMessageEditor getResponseEditor() {
        return this.responseEditor;
    }

    public MockRunner getSubmit() {
        return this.mockRunner;
    }

    protected JComponent buildStatusLabel() {
        this.statusBar = new JEditorStatusBarWithProgress();
        this.statusBar.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
        return this.statusBar;
    }

    public JEditorStatusBarWithProgress getStatusBar() {
        return this.statusBar;
    }

    protected JComponent buildContent() {
        this.moveFocusAction = new MoveFocusAction();
        this.responseEditor = this.buildResponseEditor();
        JComponent responseEditorPanel = this.createResponseEditorPanel(this.responseEditor);
        if (this.hasRequestEditor()) {
            return this.buildEverythingPanel(responseEditorPanel);
        }
        return responseEditorPanel;
    }

    private JComponent createResponseEditorPanel(MockResponseMessageEditor responseEditor) {
        if (this.hasTopEditorPanel()) {
            JSplitPane responseEditorSplit = UISupport.createVerticalSplit();
            responseEditorSplit.add(this.addTopEditorPanel());
            responseEditorSplit.add(this.addBottomEditorPanel(responseEditor));
            responseEditorSplit.setDividerLocation(200);
            return responseEditorSplit;
        }
        JPanel responseEditorPanel = new JPanel();
        responseEditorPanel.setLayout(new BoxLayout(responseEditorPanel, 1));
        responseEditorPanel.add(responseEditor);
        return responseEditorPanel;
    }

    protected Component addBottomEditorPanel(MockResponseMessageEditor responseEditor) {
        return responseEditor;
    }

    private JComponent buildEverythingPanel(JComponent responseEditorPanel) {
        JComponent component;
        this.requestSplitPane = UISupport.createHorizontalSplit();
        this.requestSplitPane.setResizeWeight(0.5);
        this.requestSplitPane.setBorder(null);
        this.splitButton = AbstractMockResponseDesktopPanel.createActionButton(new ChangeSplitPaneOrientationAction(this.requestSplitPane), true);
        this.tabsButton = new JToggleButton(new ChangeToTabsAction());
        this.tabsButton.setPreferredSize(UISupport.TOOLBAR_BUTTON_DIMENSION);
        this.requestEditor = this.buildRequestEditor();
        this.requestTabs = new JTabbedPane();
        this.requestTabPanel = UISupport.createTabPanel(this.requestTabs, true);
        if (this.mockResponse.getSettings().getBoolean(UISettings.START_WITH_REQUEST_TABS)) {
            this.requestTabs.addTab("Last Request", this.requestEditor);
            this.requestTabs.addTab("Mock Response", responseEditorPanel);
            this.splitButton.setEnabled(false);
            this.tabsButton.setSelected(true);
            component = this.requestTabPanel;
            this.requestTabs.setSelectedIndex(1);
        } else {
            this.requestSplitPane.setTopComponent(this.requestEditor);
            this.requestSplitPane.setBottomComponent(responseEditorPanel);
            this.requestSplitPane.setDividerLocation(0.5);
            component = this.requestSplitPane;
        }
        return component;
    }

    public boolean hasRequestEditor() {
        return true;
    }

    public JComponent addTopEditorPanel() {
        return new JPanel();
    }

    public boolean hasTopEditorPanel() {
        return false;
    }

    protected boolean isBidirectional() {
        return true;
    }

    protected MockResponseMessageEditor buildResponseEditor() {
        return new MockResponseMessageEditor(new MockResponseXmlDocument((MockResponse)this.mockResponse));
    }

    protected ModelItemXmlEditor<?, ?> buildRequestEditor() {
        return new MockRequestMessageEditor(new MockRequestXmlDocument((MockResponse)this.mockResponse));
    }

    protected JComponent buildToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        this.createToolbar(toolbar);
        toolbar.add(Box.createHorizontalGlue());
        if (this.hasRequestEditor()) {
            toolbar.add(this.tabsButton);
            toolbar.add(this.splitButton);
        }
        toolbar.add(UISupport.createToolbarButton(new ShowOnlineHelpAction(this.getHelpUrl())));
        return toolbar;
    }

    protected void createToolbar(JXToolBar toolbar) {
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.hasRequestEditor()) {
            this.requestEditor.getSourceEditor().setEditable(enabled);
        }
        this.responseEditor.getSourceEditor().setEditable(enabled);
        this.statusBar.setIndeterminate(!enabled);
    }

    @Override
    public boolean dependsOn(ModelItem modelItem) {
        return modelItem == this.getModelItem() || modelItem == this.mockResponse.getMockOperation() || modelItem == this.mockResponse.getMockOperation().getMockService() || modelItem == this.mockResponse.getMockOperation().getMockService().getProject();
    }

    public void setContent(JComponent content) {
        this.add((Component)content, "Center");
    }

    public void removeContent(JComponent content) {
        this.remove(content);
    }

    @Override
    public boolean onClose(boolean canCancel) {
        this.mockResponse.removePropertyChangeListener(this.propertyChangeListener);
        if (this.hasRequestEditor()) {
            this.requestEditor.release();
            this.requestEditor.getParent().remove(this.requestEditor);
            this.requestEditor = null;
        }
        this.responseEditor.release();
        this.responseEditor.getParent().remove(this.responseEditor);
        this.responseEditor = null;
        return this.release();
    }

    private class ClosePanelAction
    extends AbstractAction {
        private ClosePanelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SoapUI.getDesktop().closeDesktopPanel((ModelItem)AbstractMockResponseDesktopPanel.this.getModelItem());
        }
    }

    private class MoveFocusAction
    extends AbstractAction {
        private MoveFocusAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!AbstractMockResponseDesktopPanel.this.hasRequestEditor() || AbstractMockResponseDesktopPanel.this.requestEditor.hasFocus()) {
                AbstractMockResponseDesktopPanel.this.responseEditor.requestFocus();
            } else {
                AbstractMockResponseDesktopPanel.this.requestEditor.requestFocus();
            }
        }
    }

    public class MockResponseMessageEditor
    extends ResponseMessageXmlEditor<MockResponse, XmlDocument> {
        private RSyntaxTextArea inputArea;

        public MockResponseMessageEditor(XmlDocument document) {
            super(document, AbstractMockResponseDesktopPanel.this.mockResponse);
            if (AbstractMockResponseDesktopPanel.this.isBidirectional()) {
                XmlSourceEditorView editor = this.getSourceEditor();
                this.inputArea = editor.getInputArea();
                if (AbstractMockResponseDesktopPanel.this.hasRequestEditor()) {
                    this.inputArea.addFocusListener((FocusListener)new ResultAreaFocusListener());
                }
                if (UISupport.isMac()) {
                    this.inputArea.getInputMap().put(KeyStroke.getKeyStroke("control meta TAB"), AbstractMockResponseDesktopPanel.this.moveFocusAction);
                    this.inputArea.getInputMap().put(KeyStroke.getKeyStroke("ctrl F4"), AbstractMockResponseDesktopPanel.this.closePanelAction);
                } else {
                    this.inputArea.getInputMap().put(KeyStroke.getKeyStroke("control alt TAB"), AbstractMockResponseDesktopPanel.this.moveFocusAction);
                    this.inputArea.getInputMap().put(KeyStroke.getKeyStroke("ctrl F4"), AbstractMockResponseDesktopPanel.this.closePanelAction);
                }
                JPopupMenu inputPopup = editor.getEditorPopup();
                inputPopup.insert(new JSeparator(), 2);
            }
        }

        @Override
        protected void selectDefaultView() {
        }

        public RSyntaxTextArea getInputArea() {
            return this.inputArea;
        }
    }

    private final class InternalPropertyChangeListener
    implements PropertyChangeListener {
        private InternalPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(WsdlMockResponse.MOCKRESULT_PROPERTY)) {
                MockRequest mockRequest;
                MockResult mockResult = AbstractMockResponseDesktopPanel.this.mockResponse.getMockResult();
                MockRequest mockRequest2 = mockRequest = mockResult == null ? null : mockResult.getMockRequest();
                if (AbstractMockResponseDesktopPanel.this.hasRequestEditor()) {
                    ((XmlDocument)AbstractMockResponseDesktopPanel.this.requestEditor.getDocument()).setDocumentContent(new DocumentContent(mockRequest == null ? "" : mockRequest.getHttpRequest().getContentType(), mockRequest == null ? "" : mockRequest.getRequestContent()));
                }
            }
        }
    }

    private final class ChangeToTabsAction
    extends AbstractAction {
        public ChangeToTabsAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/toggle_tabs.gif"));
            this.putValue("ShortDescription", "Toggles to tab-based layout");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AbstractMockResponseDesktopPanel.this.splitButton.isEnabled()) {
                AbstractMockResponseDesktopPanel.this.splitButton.setEnabled(false);
                AbstractMockResponseDesktopPanel.this.removeContent(AbstractMockResponseDesktopPanel.this.requestSplitPane);
                AbstractMockResponseDesktopPanel.this.setContent(AbstractMockResponseDesktopPanel.this.requestTabPanel);
                AbstractMockResponseDesktopPanel.this.requestTabs.addTab("Last Request", AbstractMockResponseDesktopPanel.this.requestEditor);
                AbstractMockResponseDesktopPanel.this.requestTabs.addTab("Mock Response", AbstractMockResponseDesktopPanel.this.responseEditor);
            } else {
                int selectedIndex = AbstractMockResponseDesktopPanel.this.requestTabs.getSelectedIndex();
                AbstractMockResponseDesktopPanel.this.splitButton.setEnabled(true);
                AbstractMockResponseDesktopPanel.this.removeContent(AbstractMockResponseDesktopPanel.this.requestTabPanel);
                AbstractMockResponseDesktopPanel.this.setContent(AbstractMockResponseDesktopPanel.this.requestSplitPane);
                AbstractMockResponseDesktopPanel.this.requestSplitPane.setTopComponent(AbstractMockResponseDesktopPanel.this.requestEditor);
                AbstractMockResponseDesktopPanel.this.requestSplitPane.setBottomComponent(AbstractMockResponseDesktopPanel.this.responseEditor);
                AbstractMockResponseDesktopPanel.this.requestSplitPane.setDividerLocation(0.5);
                if (selectedIndex == 0) {
                    AbstractMockResponseDesktopPanel.this.requestEditor.requestFocus();
                } else {
                    AbstractMockResponseDesktopPanel.this.responseEditor.requestFocus();
                }
            }
            AbstractMockResponseDesktopPanel.this.revalidate();
        }
    }

    public class MockRequestMessageEditor
    extends RequestMessageXmlEditor<MockResponse, XmlDocument> {
        public MockRequestMessageEditor(XmlDocument document) {
            super(document, AbstractMockResponseDesktopPanel.this.mockResponse);
        }

        protected XmlSourceEditorView<?> buildSourceEditor() {
            XmlSourceEditorView editor = this.getSourceEditor();
            RSyntaxTextArea inputArea = editor.getInputArea();
            inputArea.addFocusListener((FocusListener)new InputAreaFocusListener());
            if (UISupport.isMac()) {
                inputArea.getInputMap().put(KeyStroke.getKeyStroke("control meta TAB"), AbstractMockResponseDesktopPanel.this.moveFocusAction);
            } else {
                inputArea.getInputMap().put(KeyStroke.getKeyStroke("control alt TAB"), AbstractMockResponseDesktopPanel.this.moveFocusAction);
            }
            inputArea.getInputMap().put(KeyStroke.getKeyStroke("ctrl F4"), AbstractMockResponseDesktopPanel.this.closePanelAction);
            return editor;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            super.propertyChange(evt);
            if (evt.getPropertyName().equals(EditorDocument.DOCUMENT_PROPERTY)) {
                this.selectDefaultView();
            }
        }
    }

    protected final class ResultAreaFocusListener
    implements FocusListener {
        protected ResultAreaFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            int maximumDividerLocation;
            AbstractMockResponseDesktopPanel.this.responseHasFocus = true;
            if (!AbstractMockResponseDesktopPanel.this.splitButton.isEnabled()) {
                AbstractMockResponseDesktopPanel.this.requestTabs.setSelectedIndex(1);
                return;
            }
            if (AbstractMockResponseDesktopPanel.this.getModelItem().getSettings().getBoolean(UISettings.NO_RESIZE_REQUEST_EDITOR)) {
                return;
            }
            if (((SoapUISplitPaneUI)AbstractMockResponseDesktopPanel.this.requestSplitPane.getUI()).hasBeenDragged()) {
                return;
            }
            int pos = AbstractMockResponseDesktopPanel.this.requestSplitPane.getDividerLocation();
            if (pos + 600 < (maximumDividerLocation = AbstractMockResponseDesktopPanel.this.requestSplitPane.getMaximumDividerLocation())) {
                return;
            }
            if (maximumDividerLocation > 700) {
                AbstractMockResponseDesktopPanel.this.requestSplitPane.setDividerLocation(maximumDividerLocation - 600);
            } else {
                AbstractMockResponseDesktopPanel.this.requestSplitPane.setDividerLocation(0.2);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }

    protected final class InputAreaFocusListener
    implements FocusListener {
        protected InputAreaFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            AbstractMockResponseDesktopPanel.this.responseHasFocus = false;
            if (!AbstractMockResponseDesktopPanel.this.splitButton.isEnabled()) {
                AbstractMockResponseDesktopPanel.this.requestTabs.setSelectedIndex(0);
                return;
            }
            if (AbstractMockResponseDesktopPanel.this.getModelItem().getSettings().getBoolean(UISettings.NO_RESIZE_REQUEST_EDITOR)) {
                return;
            }
            if (((SoapUISplitPaneUI)AbstractMockResponseDesktopPanel.this.requestSplitPane.getUI()).hasBeenDragged()) {
                return;
            }
            int pos = AbstractMockResponseDesktopPanel.this.requestSplitPane.getDividerLocation();
            if (pos >= 600) {
                return;
            }
            if (AbstractMockResponseDesktopPanel.this.requestSplitPane.getMaximumDividerLocation() > 700) {
                AbstractMockResponseDesktopPanel.this.requestSplitPane.setDividerLocation(600);
            } else {
                AbstractMockResponseDesktopPanel.this.requestSplitPane.setDividerLocation(0.8);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }
}

