/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.x.form.support;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.support.MessageSupport;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormDialogBuilder;
import com.eviware.x.form.XFormFactory;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormTextField;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import com.eviware.x.form.support.APage;
import com.eviware.x.form.support.XFormMultiSelectList;
import com.eviware.x.form.support.XFormRadioGroup;
import com.eviware.x.form.support.XFormRadioGroupTopButtonPosition;
import com.eviware.x.impl.swing.ActionFormFieldComponent;
import com.eviware.x.impl.swing.JComponentFormField;
import com.eviware.x.impl.swing.JLabelFormField;
import com.eviware.x.impl.swing.JMultilineLabelTextField;
import com.eviware.x.impl.swing.JPasswordFieldFormField;
import com.eviware.x.impl.swing.JStringListFormField;
import com.eviware.x.impl.swing.JTableFormField;
import com.jgoodies.forms.layout.FormLayout;
import java.lang.reflect.Field;
import org.apache.commons.lang.StringUtils;

public class ADialogBuilder {
    public static XFormDialog buildDialog(Class<? extends Object> formClass) {
        return ADialogBuilder.buildDialog(formClass, null, null);
    }

    public static XFormDialog buildDialog(Class<? extends Object> formClass, ActionList actions) {
        return ADialogBuilder.buildDialog(formClass, actions, null);
    }

    public static XFormDialog buildDialog(Class<? extends Object> formClass, ActionList actions, FormLayout layout) {
        ActionList defaultActions;
        AForm formAnnotation = formClass.getAnnotation(AForm.class);
        if (formAnnotation == null) {
            throw new RuntimeException("formClass is not annotated correctly..");
        }
        MessageSupport messages = MessageSupport.getMessages(formClass);
        XFormDialogBuilder builder = XFormFactory.createDialogBuilder(messages.get(formAnnotation.name()));
        XForm form = ADialogBuilder.createForm(builder, layout);
        for (Field field : formClass.getFields()) {
            AField fieldAnnotation = field.getAnnotation(AField.class);
            if (fieldAnnotation == null) continue;
            try {
                ADialogBuilder.addFormField(form, field, fieldAnnotation, messages);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ActionList actionList = defaultActions = StringUtils.isBlank((String)formAnnotation.helpUrl()) ? builder.buildOkCancelActions() : builder.buildOkCancelHelpActions(formAnnotation.helpUrl());
        if (actions == null) {
            actions = defaultActions;
        } else {
            actions.addActions(defaultActions);
        }
        XFormDialog dialog = builder.buildDialog(actions, messages.get(formAnnotation.description()), UISupport.createImageIcon(formAnnotation.icon()));
        return dialog;
    }

    private static XForm createForm(XFormDialogBuilder builder, FormLayout layout) {
        if (layout == null) {
            return builder.createForm("Basic");
        }
        return builder.createForm("Basic", layout);
    }

    public static XFormDialog buildDialog(Class<? extends Object> formClass, ActionList actions, boolean useDefaultOkCancel) {
        ActionList defaultActions;
        if (useDefaultOkCancel) {
            return ADialogBuilder.buildDialog(formClass, actions);
        }
        AForm formAnnotation = formClass.getAnnotation(AForm.class);
        if (formAnnotation == null) {
            throw new RuntimeException("formClass is not annotated correctly..");
        }
        MessageSupport messages = MessageSupport.getMessages(formClass);
        XFormDialogBuilder builder = XFormFactory.createDialogBuilder(messages.get(formAnnotation.name()));
        XForm form = ADialogBuilder.createForm(builder, null);
        for (Field field : formClass.getFields()) {
            AField fieldAnnotation = field.getAnnotation(AField.class);
            if (fieldAnnotation == null) continue;
            try {
                ADialogBuilder.addFormField(form, field, fieldAnnotation, messages);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ActionList actionList = defaultActions = StringUtils.isBlank((String)formAnnotation.helpUrl()) ? null : builder.buildHelpActions(formAnnotation.helpUrl());
        if (actions == null) {
            actions = defaultActions;
        } else {
            actions.insertAction(defaultActions.getActionAt(0), 0);
        }
        XFormDialog dialog = builder.buildDialog(actions, messages.get(formAnnotation.description()), UISupport.createImageIcon(formAnnotation.icon()));
        return dialog;
    }

    public static XFormDialog buildTabbedDialog(Class<? extends Object> tabbedFormClass, ActionList actions) {
        ActionList defaultActions;
        AForm formAnnotation = tabbedFormClass.getAnnotation(AForm.class);
        if (formAnnotation == null) {
            throw new RuntimeException("formClass is not annotated correctly..");
        }
        MessageSupport messages = MessageSupport.getMessages(tabbedFormClass);
        XFormDialogBuilder builder = XFormFactory.createDialogBuilder(formAnnotation.name());
        for (Field field : tabbedFormClass.getFields()) {
            AField fieldAnnotation;
            APage pageAnnotation = field.getAnnotation(APage.class);
            if (pageAnnotation != null) {
                ADialogBuilder.buildForm(builder, pageAnnotation.name(), field.getType(), messages);
            }
            if ((fieldAnnotation = field.getAnnotation(AField.class)) == null) continue;
            try {
                Class<?> formClass = Class.forName(fieldAnnotation.description());
                ADialogBuilder.buildForm(builder, fieldAnnotation.name(), formClass, messages);
            }
            catch (Exception e) {
                SoapUI.logError(e);
            }
        }
        ActionList actionList = defaultActions = StringUtils.isBlank((String)formAnnotation.helpUrl()) ? builder.buildOkCancelActions() : builder.buildOkCancelHelpActions(formAnnotation.helpUrl());
        if (actions == null) {
            actions = defaultActions;
        } else {
            actions.addActions(defaultActions);
        }
        XFormDialog dialog = builder.buildDialog(actions, formAnnotation.description(), UISupport.createImageIcon(formAnnotation.icon()));
        return dialog;
    }

    public static XFormDialog buildTabbedDialogWithCustomActions(Class<? extends Object> tabbedFormClass, ActionList actions) {
        ActionList defaultActions;
        AForm formAnnotation = tabbedFormClass.getAnnotation(AForm.class);
        if (formAnnotation == null) {
            throw new RuntimeException("formClass is not annotated correctly..");
        }
        MessageSupport messages = MessageSupport.getMessages(tabbedFormClass);
        XFormDialogBuilder builder = XFormFactory.createDialogBuilder(formAnnotation.name());
        for (Field field : tabbedFormClass.getFields()) {
            AField fieldAnnotation;
            APage pageAnnotation = field.getAnnotation(APage.class);
            if (pageAnnotation != null) {
                ADialogBuilder.buildForm(builder, pageAnnotation.name(), field.getType(), messages);
            }
            if ((fieldAnnotation = field.getAnnotation(AField.class)) == null) continue;
            try {
                Class<?> formClass = Class.forName(fieldAnnotation.description());
                ADialogBuilder.buildForm(builder, fieldAnnotation.name(), formClass, messages);
            }
            catch (Exception e) {
                SoapUI.logError(e);
            }
        }
        ActionList actionList = defaultActions = StringUtils.isBlank((String)formAnnotation.helpUrl()) ? null : builder.buildHelpActions(formAnnotation.helpUrl());
        if (actions == null) {
            actions = defaultActions;
        } else {
            defaultActions.addActions(actions);
            actions = defaultActions;
        }
        XFormDialog dialog = builder.buildDialog(actions, formAnnotation.description(), UISupport.createImageIcon(formAnnotation.icon()));
        return dialog;
    }

    public static XFormDialog buildWizard(Class<? extends Object> tabbedFormClass) {
        AForm formAnnotation = tabbedFormClass.getAnnotation(AForm.class);
        if (formAnnotation == null) {
            throw new RuntimeException("formClass is not annotated correctly..");
        }
        MessageSupport messages = MessageSupport.getMessages(tabbedFormClass);
        XFormDialogBuilder builder = XFormFactory.createDialogBuilder(formAnnotation.name());
        for (Field field : tabbedFormClass.getFields()) {
            APage pageAnnotation = field.getAnnotation(APage.class);
            if (pageAnnotation == null) continue;
            ADialogBuilder.buildForm(builder, pageAnnotation.name(), field.getType(), messages);
        }
        XFormDialog dialog = builder.buildWizard(formAnnotation.description(), UISupport.createImageIcon(formAnnotation.icon()), formAnnotation.helpUrl());
        return dialog;
    }

    private static void buildForm(XFormDialogBuilder builder, String name, Class<?> formClass, MessageSupport messages) {
        XForm form = builder.createForm(name);
        for (Field formField : formClass.getFields()) {
            AField formFieldAnnotation = formField.getAnnotation(AField.class);
            if (formFieldAnnotation == null) continue;
            try {
                ADialogBuilder.addFormField(form, formField, formFieldAnnotation, messages);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void addFormField(XForm form, Field formField, AField fieldAnnotation, MessageSupport messages) throws Exception {
        AField.AFieldType type = fieldAnnotation.type();
        String fieldName = fieldAnnotation.name();
        String name = messages.get(fieldName.length() == 0 ? formField.get(null).toString() : fieldName);
        String description = messages.get(fieldAnnotation.description());
        Object[] values = messages.getArray(fieldAnnotation.values());
        String defaultValue = messages.get(fieldAnnotation.defaultValue());
        boolean enabled = fieldAnnotation.enabled();
        XFormField field = null;
        switch (type) {
            case STRING: {
                field = form.addTextField(name, description, XForm.FieldType.TEXT);
                break;
            }
            case INT: {
                field = form.addTextField(name, description, XForm.FieldType.TEXT);
                ((XFormTextField)field).setWidth(10);
                break;
            }
            case STRINGAREA: {
                field = form.addTextField(name, description, XForm.FieldType.TEXTAREA);
                break;
            }
            case BOOLEAN: {
                field = form.addCheckBox(name, description);
                break;
            }
            case FILE: {
                field = form.addTextField(name, description, XForm.FieldType.FILE);
                break;
            }
            case FOLDER: {
                field = form.addTextField(name, description, XForm.FieldType.FOLDER);
                break;
            }
            case FILE_OR_FOLDER: {
                field = form.addTextField(name, description, XForm.FieldType.FILE_OR_FOLDER);
                break;
            }
            case ENUMERATION: {
                field = form.addComboBox(name, values, description);
                break;
            }
            case RADIOGROUP: {
                field = form.addComponent(name, new XFormRadioGroup((String[])values));
                break;
            }
            case MULTILIST: {
                field = form.addComponent(name, new XFormMultiSelectList((String[])values));
                break;
            }
            case STRINGLIST: {
                field = form.addComponent(name, new JStringListFormField(description, defaultValue));
                break;
            }
            case TABLE: {
                field = form.addComponent(name, new JTableFormField(description));
                break;
            }
            case ACTION: {
                field = form.addComponent(name, new ActionFormFieldComponent(name, description));
                break;
            }
            case COMPONENT: {
                field = form.addComponent(name, new JComponentFormField(name, description));
                break;
            }
            case PASSWORD: {
                field = form.addComponent(name, new JPasswordFieldFormField());
                break;
            }
            case INFORMATION: {
                field = form.addComponent(name, new JMultilineLabelTextField());
                break;
            }
            case LABEL: {
                field = form.addComponent(name, new JLabelFormField(description));
                break;
            }
            case SEPARATOR: {
                form.addSeparator(description);
                break;
            }
            case RADIOGROUP_TOP_BUTTON: {
                field = form.addComponent(name, new XFormRadioGroupTopButtonPosition((String[])values));
                break;
            }
            case COMBOBOX: {
                field = form.addComboBox(name, values, description);
                break;
            }
            default: {
                System.out.println("Unsupported field type: " + type);
            }
        }
        if (field != null) {
            field.setEnabled(enabled);
        }
    }
}

