/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.soapui.core;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;

public class Logging {
    public static final String HTTP_CLIENT_WIRE_LOG_CATEGORY = "org.apache.http.wire";
    public static final Marker HTTP_CLIENT_WIRE_LOG_TIMESTAMP_MARKER_OUTGOING = MarkerManager.getMarker((String)"HTTP_WIRE_TIMESTAMP_OUTGOING");
    public static final Marker HTTP_CLIENT_WIRE_LOG_TIMESTAMP_MARKER_INCOMING = MarkerManager.getMarker((String)"HTTP_WIRE_TIMESTAMP_INCOMING");
    public static final String GLOBAL_GROOVY_LOG = "GLOBAL_GROOVY_LOG";

    public static Logger ensureGroovyLog() {
        return LogManager.getLogger((String)"groovy.log");
    }

    public static void addAppender(String loggerName, Appender appender) {
        Logging.addAppender(loggerName, appender, null);
    }

    public static void addAppender(String loggerName, Appender appender, Level level) {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig(loggerName);
        if (!loggerName.equals(loggerConfig.getName())) {
            loggerConfig = LoggerConfig.createLogger((boolean)loggerConfig.isAdditive(), (Level)loggerConfig.getLevel(), (String)loggerName, (String)"true", (AppenderRef[])new AppenderRef[]{AppenderRef.createAppenderRef((String)appender.getName(), (Level)level, null)}, null, (Configuration)config, null);
            config.addLogger(loggerName, loggerConfig);
        }
        appender.start();
        loggerConfig.addAppender(appender, level, null);
        context.updateLoggers();
    }

    public static void removeAppender(String loggerName, Appender appender) {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig(loggerName);
        loggerConfig.removeAppender(appender.getName());
        context.updateLoggers();
    }

    public static Appender getAppender(String name) {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        return context.getConfiguration().getAppender(name);
    }
}

