/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.swagger;

import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.support.PathUtils;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import com.smartbear.swagger.SwaggerImporter;
import com.smartbear.swagger.SwaggerUtils;
import java.io.File;

public class AddSwaggerAction
extends AbstractSoapUIAction<ModelItem> {
    public static final String DEFAULT_MEDIA_TYPE = "application/json";
    private XFormDialog dialog;

    public AddSwaggerAction() {
        super("Import Swagger/OpenAPI Definition", "Imports a Swagger/OpenAPI definition into SoapUI");
    }

    @Override
    public void perform(ModelItem modelItem, Object param) {
        if (this.dialog == null) {
            this.dialog = ADialogBuilder.buildDialog(Form.class, null, null);
            this.dialog.setValue("Default Media Type", DEFAULT_MEDIA_TYPE);
        } else {
            this.dialog.setValue("Swagger/OpenAPI Definition", "");
        }
        while (this.dialog.show()) {
            try {
                String url = this.dialog.getValue("Swagger/OpenAPI Definition").trim();
                if (!StringUtils.hasContent(url)) continue;
                WsdlProject wsdlProject = (WsdlProject)ModelSupport.getModelItemProject(modelItem);
                String expUrl = PathUtils.expandPath(url, wsdlProject);
                if (new File(expUrl).exists()) {
                    expUrl = new File(expUrl).toURI().toURL().toString();
                }
                this.importSwaggerDefinition(wsdlProject, expUrl, this.dialog.getValue("Default Media Type"));
                break;
            }
            catch (Exception ex) {
                UISupport.showErrorMessage(ex);
            }
        }
    }

    public SwaggerImporter importSwaggerDefinition(WsdlProject project, String definitionUrl, String defaultMediaType) throws Exception {
        SwaggerImporter importer = SwaggerUtils.importSwaggerFromUrl(project, definitionUrl, defaultMediaType);
        return importer;
    }

    @AForm(name="Add Swagger/OpenAPI Definition", description="Creates a REST API from the specified Swagger/OpenAPI definition")
    public static interface Form {
        @AField(name="Swagger/OpenAPI Definition", description="Location or URL of Swagger/OpenAPI definition", type=AField.AFieldType.FILE)
        public static final String SWAGGER_URL = "Swagger/OpenAPI Definition";
        @AField(name="Default Media Type", description="Default Media Type of the responses", type=AField.AFieldType.STRING)
        public static final String DEFAULT_MEDIA_TYPE = "Default Media Type";
    }
}

