/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.inflector.controllers;

import io.swagger.config.FilterFactory;
import io.swagger.core.filter.SwaggerSpecFilter;
import io.swagger.inflector.config.SwaggerProcessor;
import io.swagger.inflector.utils.VendorSpecFilter;
import io.swagger.models.Swagger;
import io.swagger.util.Json;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.process.Inflector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerResourceController
implements Inflector<ContainerRequestContext, Response> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwaggerResourceController.class);
    private Swagger swagger;
    private List<SwaggerProcessor> swaggerProcessors;

    public SwaggerResourceController(Swagger swagger, List<String> swaggerProcessors) {
        this.swagger = swagger;
        this.swaggerProcessors = new ArrayList<SwaggerProcessor>(swaggerProcessors.size());
        for (String swaggerProcessorClass : swaggerProcessors) {
            try {
                this.swaggerProcessors.add((SwaggerProcessor)SwaggerResourceController.class.getClassLoader().loadClass(swaggerProcessorClass).newInstance());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                LOGGER.error("Unable to load class: " + swaggerProcessorClass, (Throwable)e);
            }
        }
    }

    public Response apply(ContainerRequestContext arg0) {
        SwaggerSpecFilter filter = FilterFactory.getFilter();
        if (filter != null) {
            Map cookiesvalue = arg0.getCookies();
            HashMap<String, String> cookies = new HashMap<String, String>();
            if (cookiesvalue != null) {
                for (String key : cookiesvalue.keySet()) {
                    cookies.put(key, ((Cookie)cookiesvalue.get(key)).getValue());
                }
            }
            MultivaluedMap headers = arg0.getHeaders();
            return Response.ok().entity((Object)new VendorSpecFilter().filter(this.getSwagger(), filter, null, cookies, (Map)headers)).build();
        }
        return Response.ok().entity((Object)this.getSwagger()).build();
    }

    private Swagger getSwagger() {
        if (!this.swaggerProcessors.isEmpty()) {
            try {
                Swagger swagger = (Swagger)Json.mapper().readValue(Json.mapper().writeValueAsString((Object)this.swagger), Swagger.class);
                for (SwaggerProcessor swaggerProcessor : this.swaggerProcessors) {
                    swaggerProcessor.process(swagger);
                }
                return swagger;
            }
            catch (IOException e) {
                LOGGER.error("Unable to serialize/deserialize swagger: " + this.swagger, (Throwable)e);
            }
        }
        return this.swagger;
    }
}

