/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.Util;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.formcomponents.LeadingLabelComponent;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.frontend.components.AbstractFileSelector;
import com.install4j.runtime.installer.frontend.components.FileValidator;
import com.install4j.runtime.installer.helper.Logger;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JTextField;

public abstract class AbstractFileChooserComponent
extends LeadingLabelComponent
implements FileValidator {
    private String variableName = "";
    private String initialFile = "";
    private String initialBrowserDirectory = "";
    private boolean manualEntryAllowed = true;
    private ScriptProperty validationScript;
    private AbstractFileSelector fileSelector;

    protected abstract AbstractFileSelector createFileSelector();

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String string) {
        this.variableName = string;
    }

    public String getInitialFile() {
        return AbstractFileChooserComponent.replaceVariables(this.initialFile);
    }

    public void setInitialFile(String string) {
        this.initialFile = string;
    }

    public String getInitialBrowserDirectory() {
        return AbstractFileChooserComponent.replaceVariables(this.initialBrowserDirectory);
    }

    public void setInitialBrowserDirectory(String string) {
        this.initialBrowserDirectory = string;
    }

    public boolean isManualEntryAllowed() {
        return this.manualEntryAllowed;
    }

    public void setManualEntryAllowed(boolean bl) {
        this.manualEntryAllowed = bl;
    }

    public ScriptProperty getValidationScript() {
        return this.validationScript;
    }

    public void setValidationScript(ScriptProperty scriptProperty) {
        this.validationScript = scriptProperty;
    }

    public void setFormEnvironment(FormEnvironment formEnvironment) {
        super.setFormEnvironment(formEnvironment);
        if (this.fileSelector != null && formEnvironment != null) {
            String string = formEnvironment.getId(this);
            this.fileSelector.getTextField().setName(string);
            this.fileSelector.getButton().setName(string);
        }
    }

    public JComponent createCenterComponent() {
        this.fileSelector = this.createFileSelector();
        this.fileSelector.setManualEntryAllowed(this.manualEntryAllowed);
        this.fileSelector.setValidator(this);
        return (JComponent)((Object)this.fileSelector);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.fileSelector.getButton().setEnabled(bl);
    }

    public Object getConfigurationObject() {
        return this.fileSelector.getTextField();
    }

    public Class getConfigurationObjectClass() {
        return JTextField.class;
    }

    public boolean checkCompleted() {
        if (!this.isEnabled() || !this.isVisible()) {
            return true;
        }
        File file = this.fileSelector.getSelectedFile();
        if (this.fileSelector.checkSelectedFile()) {
            this.getContext().setVariable(this.getVariableName(), file == null ? null : file.getPath());
            this.getContext().registerResponseFileVariable(this.getVariableName());
            return true;
        }
        return false;
    }

    public void initialize() {
        super.initialize();
        String string = this.getInitValue();
        if (string.length() > 0) {
            this.fileSelector.setSelectedFile(new File(string));
        }
        this.fileSelector.setInitialBrowserDirectory(this.getInitialBrowserDirectory().trim());
    }

    private String getInitValue() {
        String string = (String)this.getInitValue(this.getInitialFile(), this.getVariableName(), String.class);
        if (string == null) {
            return "";
        }
        return string.trim();
    }

    public boolean isFillCenterHorizontal() {
        return true;
    }

    public boolean handleConsole(Console console) throws UserCanceledException {
        do {
            String string = this.initialFile.length() > 0 || this.getInitValue().length() > 0 ? this.fileSelector.getSelectedFile().getAbsolutePath() : "";
            File file = new File(console.askString(this.getConsoleLabelText(false), string));
            this.fileSelector.setSelectedFile(file);
        } while (!this.fileSelector.checkSelectedFile());
        return true;
    }

    public boolean isValidFile(File file) {
        if (this.validationScript != null) {
            try {
                return ContextImpl.getContextInt(this.getContext()).runBooleanScript(this.validationScript.getValue(), this, new Object[]{file, this.getFormEnvironment()});
            }
            catch (Exception exception) {
                Util.printAnnotatedStackTrace(exception);
                Logger.getInstance().log(exception);
            }
        }
        return true;
    }
}

