/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.analytics;

import com.smartbear.analytics.ActionDescription;
import com.smartbear.analytics.AnalyticsUtils;
import com.smartbear.analytics.OSUserDescription;
import com.smartbear.analytics.api.AnalyticsProvider;
import com.smartbear.analytics.api.AnalyticsProviderFactory;
import com.smartbear.analytics.impl.UserInfoProvider;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;

public class AnalyticsManager {
    private static AnalyticsManager instance = null;
    private List<AnalyticsProvider> providers = new CopyOnWriteArrayList<AnalyticsProvider>();
    private String sessionId;
    private List<AnalyticsProviderFactory> factories = new ArrayList<AnalyticsProviderFactory>();
    private Executor executorService;
    private boolean disableProviders = false;

    private AnalyticsManager() {
        String startTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        this.sessionId = AnalyticsManager.makeUserId() + ":" + startTime;
    }

    static AnalyticsManager getInstance() {
        if (instance == null) {
            instance = new AnalyticsManager();
        }
        return instance;
    }

    public void setExecutorService(Executor executorService) {
        this.executorService = executorService;
    }

    boolean trackAction(String actionName) {
        return this.trackAction(Category.ACTION, actionName, null);
    }

    void trackAction(String action, Map<String, String> params) {
        this.trackAction(Category.ACTION, action, params);
    }

    void trackError(final Throwable error) {
        if (this.providers.isEmpty()) {
            return;
        }
        this.runInBackground(new Runnable(){

            @Override
            public void run() {
                for (AnalyticsProvider provider : AnalyticsManager.this.providers) {
                    provider.trackError(error);
                }
            }
        });
    }

    void trackLicenseData(String actionName, Map<String, String> parameterMap) {
        this.trackAction(Category.LICENSE_UPDATE, actionName, parameterMap);
    }

    boolean trackCustomPlugInAction(String actionName, Map<String, String> parameterMap) {
        return this.trackAction(Category.CUSTOM_PLUGIN_ACTION, actionName, parameterMap);
    }

    public boolean trackSessionStart(String type) {
        return this.trackAction(Category.SESSION_START, type, null);
    }

    public boolean trackSessionStop(String type) {
        return this.trackAction(Category.SESSION_STOP, type, null);
    }

    public boolean trackSessionStart() {
        return this.trackSessionStart("");
    }

    public boolean trackSessionStop() {
        return this.trackSessionStop("");
    }

    public boolean trackStatistics(String name, Map<String, String> params) {
        return this.trackAction(Category.STATISTICS, name, params);
    }

    public void registerAnalyticsProviderFactory(AnalyticsProviderFactory factory) {
        this.factories.add(factory);
        this.registerActiveProvider(factory.allocateProvider(), false);
    }

    public boolean selectAnalyticsProvider(String name, boolean keepTheOnlyOne) {
        for (AnalyticsProviderFactory factory : this.factories) {
            if (factory.getName().compareToIgnoreCase(name) != 0) continue;
            this.registerActiveProvider(factory.allocateProvider(), keepTheOnlyOne);
            return true;
        }
        if (keepTheOnlyOne) {
            this.providers.clear();
        }
        return false;
    }

    public void clearProviders() {
        this.providers.clear();
    }

    protected void disableProviders(boolean value) {
        this.disableProviders = value;
    }

    protected void registerActiveProvider(AnalyticsProvider provider, boolean keepTheOnlyOne) {
        if (keepTheOnlyOne) {
            this.providers.clear();
        }
        this.providers.add(provider);
    }

    private static String makeUserId() {
        return AnalyticsUtils.getMacAddressString();
    }

    public boolean trackAction(Category category, String actionName, Map<String, String> params) {
        if (this.providers.isEmpty() || this.disableProviders) {
            return false;
        }
        final ActionDescription description = new ActionDescription(this.sessionId, category, actionName, params);
        this.runInBackground(new Runnable(){

            @Override
            public void run() {
                for (AnalyticsProvider provider : AnalyticsManager.this.providers) {
                    provider.trackAction(description);
                }
            }
        });
        return this.providers.size() > 0;
    }

    public boolean trackUserInfo(final OSUserDescription osUserDescription) {
        if (this.providers.isEmpty() || this.disableProviders) {
            return false;
        }
        this.runInBackground(new Runnable(){

            @Override
            public void run() {
                for (AnalyticsProvider provider : AnalyticsManager.this.providers) {
                    if (!(provider instanceof UserInfoProvider)) continue;
                    ((UserInfoProvider)((Object)provider)).trackUserInfo(osUserDescription);
                }
            }
        });
        return true;
    }

    private void runInBackground(Runnable runnable) {
        if (this.executorService != null) {
            this.executorService.execute(runnable);
        } else {
            new Thread(runnable).start();
        }
    }

    public static enum Category {
        SESSION_START,
        SESSION_STOP,
        STATISTICS,
        ACTION,
        CUSTOM_PLUGIN_ACTION,
        LICENSE_UPDATE,
        VIRTSERVER,
        READYAPISERVER,
        MIXPANEL_PROFILE;

    }
}

