/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.extras.api.painterpack.fill;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.colorscheme.ColorSchemeTransform;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.fill.RadianceFillPainter;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;

public abstract class WaveDelegateFillPainter
implements RadianceFillPainter {
    private String painterName;
    private ColorSchemeTransform transformation;
    private RadianceFillPainter delegate;

    public WaveDelegateFillPainter(String painterName, ColorSchemeTransform transformation, RadianceFillPainter delegate) {
        this.painterName = painterName;
        this.transformation = transformation;
        this.delegate = delegate;
    }

    public String getDisplayName() {
        return this.painterName;
    }

    public void paintContourBackground(Graphics g, Component comp, float width, float height, Shape contour, boolean isFocused, RadianceColorScheme fillScheme, boolean hasShine) {
        double scale = RadianceCommonCortex.getScaleFactor((Component)comp);
        GeneralPath clipBottom = new GeneralPath();
        clipBottom.moveTo(0.0f, height);
        clipBottom.lineTo(width, height);
        clipBottom.lineTo(width, 0.0f);
        clipBottom.curveTo(5.0f * width / 6.0f, height / 3.0f, 3.0f * width / 4.0f, height / 2.0f, width / 2.0f, height / 2.0f);
        clipBottom.curveTo(width / 3.0f, height / 2.0f, width / 4.0f, height, 0.0f, 7.0f * height / 8.0f);
        clipBottom.lineTo(0.0f, height);
        int iWidth = (int)Math.ceil(width);
        int iHeight = (int)Math.ceil(height);
        BufferedImage clipShapeBottom = RadianceCoreUtilities.softClip((double)RadianceCommonCortex.getScaleFactor((Component)comp), (int)iWidth, (int)iHeight, null, (Shape)clipBottom);
        BufferedImage bottomImage = RadianceCoreUtilities.getBlankImage((double)scale, (int)iWidth, (int)iHeight);
        Graphics2D bottomGraphics = (Graphics2D)bottomImage.getGraphics();
        bottomGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RadianceColorScheme bottomColorScheme = this.transformation == null ? fillScheme : this.transformation.transform(fillScheme);
        bottomGraphics.setComposite(AlphaComposite.Src);
        bottomGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        bottomGraphics.drawImage((Image)clipShapeBottom, 0, 0, null);
        bottomGraphics.setComposite(AlphaComposite.SrcAtop);
        this.delegate.paintContourBackground((Graphics)bottomGraphics, comp, width, height, contour, isFocused, bottomColorScheme, hasShine);
        BufferedImage image = RadianceCoreUtilities.getBlankImage((double)scale, (int)iWidth, (int)iHeight);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setClip(contour);
        this.delegate.paintContourBackground((Graphics)graphics, comp, width, height, contour, isFocused, fillScheme, hasShine);
        graphics.drawImage((Image)bottomImage, 0, 0, null);
        graphics.setClip(null);
    }
}

