/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.extras.api.shaperpack;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Shape;
import java.io.InputStream;
import javax.swing.AbstractButton;
import javax.swing.border.Border;
import org.pushingpixels.radiance.theming.api.shaper.RadianceButtonShaper;
import org.pushingpixels.radiance.theming.extras.api.shaperpack.CanonicalPath;
import org.pushingpixels.radiance.theming.extras.api.shaperpack.ShaperRepository;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceOutlineUtilities;
import org.pushingpixels.radiance.theming.internal.utils.border.RadianceButtonBorder;

public abstract class BasePolygonShaper
implements RadianceButtonShaper {
    private CanonicalPath canonicalPath;
    private double topCoef;
    private double leftCoef;
    private double bottomCoef;
    private double rightCoef;

    public BasePolygonShaper(String resourceName, double topCoef, double leftCoef, double bottomCoef, double rightCoef) {
        this.topCoef = topCoef;
        this.leftCoef = leftCoef;
        this.bottomCoef = bottomCoef;
        this.rightCoef = rightCoef;
        ClassLoader cl = BasePolygonShaper.class.getClassLoader();
        InputStream is = cl.getResourceAsStream(resourceName);
        if (is == null) {
            throw new IllegalArgumentException("Resource '" + resourceName + "' not found");
        }
        this.canonicalPath = ShaperRepository.read(is);
    }

    public Dimension getPreferredSize(AbstractButton button, Dimension uiPreferredSize) {
        if (button.getClientProperty("radiance.theming.internal.buttonbordercomputed") == null) {
            boolean isBorderComputing = button.getClientProperty("radiance.theming.internal.buttonbordercomputing") != null;
            Border border = button.getBorder();
            int uiw = uiPreferredSize.width;
            int uih = uiPreferredSize.height;
            if (border instanceof RadianceButtonBorder) {
                Insets bi = border.getBorderInsets(button);
                if (!isBorderComputing) {
                    button.setBorder(null);
                }
                uiPreferredSize.setSize(uiw - bi.left - bi.right, uih - bi.top - bi.bottom);
            } else {
                Insets bi = border.getBorderInsets(button);
                if (!isBorderComputing) {
                    button.setBorder(null);
                }
                uiPreferredSize.setSize(uiw - bi.left - bi.right, uih - bi.top - bi.bottom);
            }
            if (!isBorderComputing) {
                button.setBorder(this.getButtonBorder(uiPreferredSize));
                button.putClientProperty("radiance.theming.internal.buttonbordercomputed", new String());
            }
        }
        return uiPreferredSize;
    }

    public Border getButtonBorder(AbstractButton button) {
        return new RadianceButtonBorder(this.getClass()){

            public Insets getBorderInsets(Component c) {
                AbstractButton button;
                if (c instanceof AbstractButton && RadianceCoreUtilities.hasText((AbstractButton)(button = (AbstractButton)c))) {
                    if (button.getClientProperty("radiance.theming.internal.buttonbordercomputing") != null) {
                        return new Insets(0, 0, 0, 0);
                    }
                    button.putClientProperty("radiance.theming.internal.buttonbordercomputing", new String());
                    int width = button.getPreferredSize().width;
                    int height = button.getPreferredSize().height;
                    button.putClientProperty("radiance.theming.internal.buttonbordercomputing", null);
                    double finalWidth = (double)width * (1.0 + BasePolygonShaper.this.leftCoef + BasePolygonShaper.this.rightCoef);
                    double finalHeight = (double)height * (1.0 + BasePolygonShaper.this.topCoef + BasePolygonShaper.this.bottomCoef);
                    double finalRatio = finalWidth / finalHeight;
                    int dx = 0;
                    int dy = 0;
                    if (finalRatio > BasePolygonShaper.this.canonicalPath.getRatio()) {
                        dy = (int)(finalWidth / BasePolygonShaper.this.canonicalPath.getRatio() - finalHeight);
                    } else {
                        dx = (int)(BasePolygonShaper.this.canonicalPath.getRatio() * finalHeight - finalWidth);
                    }
                    return new Insets((int)(BasePolygonShaper.this.topCoef * (double)height) + dy / 2, (int)(BasePolygonShaper.this.leftCoef * (double)width) + dx / 2, (int)(BasePolygonShaper.this.bottomCoef * (double)height) + dy / 2, (int)(BasePolygonShaper.this.rightCoef * (double)width) + dx / 2);
                }
                return new Insets(0, 0, 0, 0);
            }
        };
    }

    public Border getButtonBorder(final Dimension preferredSize) {
        return new RadianceButtonBorder(this.getClass()){

            public Insets getBorderInsets(Component c) {
                AbstractButton button;
                if (c instanceof AbstractButton && RadianceCoreUtilities.hasText((AbstractButton)(button = (AbstractButton)c))) {
                    int width = preferredSize.width;
                    int height = preferredSize.height;
                    double finalWidth = (double)width * (1.0 + BasePolygonShaper.this.leftCoef + BasePolygonShaper.this.rightCoef);
                    double finalHeight = (double)height * (1.0 + BasePolygonShaper.this.topCoef + BasePolygonShaper.this.bottomCoef);
                    double finalRatio = finalWidth / finalHeight;
                    int dx = 0;
                    int dy = 0;
                    if (finalRatio > BasePolygonShaper.this.canonicalPath.getRatio()) {
                        dy = (int)(finalWidth / BasePolygonShaper.this.canonicalPath.getRatio() - finalHeight);
                    } else {
                        dx = (int)(BasePolygonShaper.this.canonicalPath.getRatio() * finalHeight - finalWidth);
                    }
                    return new Insets((int)(BasePolygonShaper.this.topCoef * (double)height) + dy / 2, (int)(BasePolygonShaper.this.leftCoef * (double)width) + dx / 2, (int)(BasePolygonShaper.this.bottomCoef * (double)height) + dy / 2, (int)(BasePolygonShaper.this.rightCoef * (double)width) + dx / 2);
                }
                return new Insets(0, 0, 0, 0);
            }
        };
    }

    public Shape getButtonOutline(AbstractButton button, float extraInsets, float width, float height, boolean isInner) {
        if (RadianceCoreUtilities.hasText((AbstractButton)button)) {
            return this.canonicalPath.getPath(width, height, extraInsets);
        }
        return RadianceOutlineUtilities.getBaseOutline((float)width, (float)height, (float)2.0f, null, (float)extraInsets);
    }

    public boolean isProportionate() {
        return false;
    }
}

