/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.extras.api.tabbed;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JTabbedPane;
import org.pushingpixels.radiance.theming.api.RadianceThemingWidget;
import org.pushingpixels.radiance.theming.extras.internal.tabbed.TabPreviewThread;
import org.pushingpixels.radiance.theming.extras.internal.tabbed.TabPreviewWindow;
import org.pushingpixels.radiance.theming.internal.ui.RadianceTabbedPaneUI;

public class TabHoverPreviewWidget
extends RadianceThemingWidget<JTabbedPane> {
    protected MouseRolloverHandler baseRolloverHandler;

    public void installListeners() {
        this.baseRolloverHandler = new MouseRolloverHandler();
        ((JTabbedPane)this.jcomp).addMouseMotionListener(this.baseRolloverHandler);
        ((JTabbedPane)this.jcomp).addMouseListener(this.baseRolloverHandler);
    }

    public void uninstallListeners() {
        if (this.baseRolloverHandler != null) {
            ((JTabbedPane)this.jcomp).removeMouseMotionListener(this.baseRolloverHandler);
            ((JTabbedPane)this.jcomp).removeMouseListener(this.baseRolloverHandler);
            this.baseRolloverHandler = null;
        }
    }

    public void uninstallUI() {
        if (TabPreviewThread.instanceRunning()) {
            TabPreviewThread.getInstance().cancelTabPreviewRequests(this.jcomp);
        }
        TabPreviewWindow.cancelPreviewRequest();
        super.uninstallUI();
    }

    protected class MouseRolloverHandler
    implements MouseListener,
    MouseMotionListener {
        int prevRolledOver = -1;

        protected MouseRolloverHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            TabPreviewWindow.cancelPreviewRequest();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (e.getSource() != TabHoverPreviewWidget.this.jcomp) {
                return;
            }
            RadianceTabbedPaneUI ui = (RadianceTabbedPaneUI)((JTabbedPane)TabHoverPreviewWidget.this.jcomp).getUI();
            int currRolledOver = ui.getRolloverTabIndex();
            if (currRolledOver >= ((JTabbedPane)TabHoverPreviewWidget.this.jcomp).getTabCount()) {
                return;
            }
            if (currRolledOver != ((JTabbedPane)TabHoverPreviewWidget.this.jcomp).getSelectedIndex()) {
                if (currRolledOver == this.prevRolledOver) {
                    if (currRolledOver >= 0 && currRolledOver < ((JTabbedPane)TabHoverPreviewWidget.this.jcomp).getTabCount() && ((JTabbedPane)TabHoverPreviewWidget.this.jcomp).isEnabledAt(currRolledOver)) {
                        TabPreviewWindow.getInstance().postPreviewRequest((JTabbedPane)TabHoverPreviewWidget.this.jcomp, currRolledOver);
                    }
                } else {
                    if (this.prevRolledOver >= 0 && this.prevRolledOver < ((JTabbedPane)TabHoverPreviewWidget.this.jcomp).getTabCount() && ((JTabbedPane)TabHoverPreviewWidget.this.jcomp).isEnabledAt(this.prevRolledOver)) {
                        TabPreviewWindow.cancelPreviewRequest();
                    }
                    if (currRolledOver >= 0 && currRolledOver < ((JTabbedPane)TabHoverPreviewWidget.this.jcomp).getTabCount() && ((JTabbedPane)TabHoverPreviewWidget.this.jcomp).isEnabledAt(currRolledOver)) {
                        TabPreviewWindow.getInstance().postPreviewRequest((JTabbedPane)TabHoverPreviewWidget.this.jcomp, currRolledOver);
                    }
                }
            } else {
                TabPreviewWindow.cancelPreviewRequest();
            }
            this.prevRolledOver = currRolledOver;
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (this.prevRolledOver >= 0 && this.prevRolledOver < ((JTabbedPane)TabHoverPreviewWidget.this.jcomp).getTabCount() && ((JTabbedPane)TabHoverPreviewWidget.this.jcomp).isEnabledAt(this.prevRolledOver)) {
                TabPreviewWindow.cancelPreviewRequest();
            }
            this.prevRolledOver = -1;
        }
    }
}

