/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.extras.internal.tabbed;

import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JTabbedPane;
import javax.swing.plaf.UIResource;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.extras.internal.tabbed.TabOverviewDialog;
import org.pushingpixels.radiance.theming.extras.internal.tabbed.TabPreviewUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.icon.TransitionAwareIcon;

public class TabOverviewButton
extends JButton
implements UIResource {
    private static final String OWN_BOUNDS = "radiance.theming.internal.extras.ownBounds";

    public TabOverviewButton(JTabbedPane tabPane) {
        this.setFocusable(false);
        int dimension = RadianceSizeUtils.getControlFontSize();
        this.setIcon((Icon)new TransitionAwareIcon((AbstractButton)this, scheme -> RadianceThemingCortex.GlobalScope.getIconPack().getInspectIcon(dimension, scheme), "radiance.theming.internal.widget.extras.taboverview"));
        RadianceCoreUtilities.markButtonAsFlat((AbstractButton)this);
        this.setToolTipText(TabPreviewUtilities.getLabelBundle().getString("TabbedPane.overviewButtonTooltip"));
        this.addActionListener(actionEvent -> TabOverviewDialog.getOverviewDialog(tabPane).setVisible(true));
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (Boolean.TRUE.equals(this.getClientProperty(OWN_BOUNDS))) {
            super.setBounds(x, y, width, height);
        }
    }

    public void updateLocation(JTabbedPane tabbedPane, Insets tabAreaInsets) {
        if (tabbedPane == null) {
            return;
        }
        this.putClientProperty(OWN_BOUNDS, Boolean.TRUE);
        int buttonSize = RadianceSizeUtils.getLookupButtonSize();
        switch (tabbedPane.getTabPlacement()) {
            case 1: {
                if (tabbedPane.getComponentOrientation().isLeftToRight()) {
                    this.setBounds(2, tabAreaInsets.top, buttonSize, buttonSize);
                    break;
                }
                this.setBounds(tabbedPane.getBounds().width - tabAreaInsets.right - buttonSize - 2, tabAreaInsets.top, buttonSize, buttonSize);
                break;
            }
            case 3: {
                if (tabbedPane.getComponentOrientation().isLeftToRight()) {
                    this.setBounds(2, tabbedPane.getBounds().height - tabAreaInsets.bottom - buttonSize - 4, buttonSize, buttonSize);
                    break;
                }
                this.setBounds(tabbedPane.getBounds().width - tabAreaInsets.right - buttonSize - 2, tabbedPane.getBounds().height - tabAreaInsets.bottom - buttonSize - 4, buttonSize, buttonSize);
                break;
            }
            case 2: {
                this.setBounds(2, tabAreaInsets.top - 1, buttonSize, buttonSize);
                break;
            }
            case 4: {
                this.setBounds(tabbedPane.getBounds().width - tabAreaInsets.right - buttonSize - 2, tabAreaInsets.top - 1, buttonSize, buttonSize);
            }
        }
        this.putClientProperty(OWN_BOUNDS, null);
    }
}

