/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.cache;

import javax.swing.Action;
import javax.swing.JMenu;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.client.gui.session.ObjectTreeInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SQLInternalFrame;
import net.sourceforge.squirrel_sql.client.plugin.DefaultSessionPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.plugin.PluginException;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallback;
import net.sourceforge.squirrel_sql.client.preferences.IGlobalPreferencesPanel;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreePanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.IObjectTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.sqltab.AdditionalSQLTab;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.plugins.cache.CachePluginResources;
import net.sourceforge.squirrel_sql.plugins.cache.StatisticsAndQueryPlanAction;
import net.sourceforge.squirrel_sql.plugins.cache.tap.CacheViewSourceTab;

public class CachePlugin
extends DefaultSessionPlugin {
    private Action _statisticsAndQueryPlanAction;
    private CachePluginResources _resources;

    public String getInternalName() {
        return "cache";
    }

    public String getDescriptiveName() {
        return "Intersystems Cache/IRIS Plugin";
    }

    public String getVersion() {
        return "0.01";
    }

    public String getAuthor() {
        return "Gerd Wagner, Martin Weissenborn";
    }

    public String getChangeLogFileName() {
        return "changes.txt";
    }

    public String getHelpFileName() {
        return "doc/readme.txt";
    }

    public String getLicenceFileName() {
        return "licence.txt";
    }

    public String getContributors() {
        return "";
    }

    public IGlobalPreferencesPanel[] getGlobalPreferencePanels() {
        return new IGlobalPreferencesPanel[0];
    }

    public synchronized void initialize() throws PluginException {
        this._resources = new CachePluginResources((IPlugin)this);
    }

    public PluginSessionCallback sessionStarted(final ISession session) {
        if (!DialectFactory.isIntersystemsCache((ISQLDatabaseMetaData)session.getMetaData()) && !DialectFactory.isIntersystemsIris((ISQLDatabaseMetaData)session.getMetaData())) {
            return null;
        }
        this.addStatisticsAndQueryPlanSessionMenuAction(session);
        GUIUtils.processOnSwingEventThread(() -> this.updateTreeApi(session.getSessionInternalFrame().getObjectTreeAPI()));
        return new PluginSessionCallback(){

            public void sqlInternalFrameOpened(SQLInternalFrame sqlInternalFrame, ISession sess) {
                CachePlugin.this.initSqlInternalFrame(sqlInternalFrame, session);
            }

            public void additionalSQLTabOpened(AdditionalSQLTab additionalSQLTab) {
            }

            public void objectTreeInternalFrameOpened(ObjectTreeInternalFrame objectTreeInternalFrame, ISession sess) {
                CachePlugin.this.updateTreeApi(objectTreeInternalFrame.getObjectTreeAPI());
            }

            public void objectTreeInSQLTabOpened(ObjectTreePanel objectTreePanel) {
            }
        };
    }

    private void updateTreeApi(IObjectTreeAPI objectTreeAPI) {
        CacheViewSourceTab viewSourceTab = new CacheViewSourceTab(objectTreeAPI.getSession());
        objectTreeAPI.addDetailTab(DatabaseObjectType.VIEW, (IObjectTab)viewSourceTab);
        objectTreeAPI.refreshTree();
    }

    private void initSqlInternalFrame(SQLInternalFrame sqlInternalFrame, ISession session) {
        if (!DialectFactory.isIntersystemsCache((ISQLDatabaseMetaData)session.getMetaData())) {
            return;
        }
        ActionCollection coll = Main.getApplication().getActionCollection();
        sqlInternalFrame.addSeparatorToToolbar();
        sqlInternalFrame.addToToolbar(coll.get(StatisticsAndQueryPlanAction.class));
    }

    private void addStatisticsAndQueryPlanSessionMenuAction(ISession session) {
        ActionCollection coll = Main.getApplication().getActionCollection();
        if (null == this._statisticsAndQueryPlanAction) {
            this._statisticsAndQueryPlanAction = new StatisticsAndQueryPlanAction(this._resources);
            coll.add(this._statisticsAndQueryPlanAction);
            JMenu menu = this._resources.createMenu("cache");
            Main.getApplication().addToMenu(2, menu);
            this._resources.addToMenu(this._statisticsAndQueryPlanAction, menu);
        }
        session.addSeparatorToToolbar();
        session.addToToolbar(coll.get(StatisticsAndQueryPlanAction.class));
    }

    private static interface IMenuResourceKeys {
        public static final String MENU = "cache";
    }
}

