/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.cache;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.action.ISQLPanelAction;
import net.sourceforge.squirrel_sql.client.session.mainpanel.custompanel.CustomResultPanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.textdataset.DataSetTextArea;
import net.sourceforge.squirrel_sql.fw.resources.IResources;
import net.sourceforge.squirrel_sql.fw.sql.querytokenizer.IQueryTokenizer;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.cache.CachePluginResources;
import net.sourceforge.squirrel_sql.plugins.cache.CacheStatsAndQueryPlanReader;

public class StatisticsAndQueryPlanAction
extends SquirrelAction
implements ISQLPanelAction {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(StatisticsAndQueryPlanAction.class);
    private static final ILogger s_log = LoggerController.createLogger(StatisticsAndQueryPlanAction.class);
    private final ExecutorService _executorService = Executors.newCachedThreadPool();
    private ISQLPanelAPI _sqlPanelAPI;
    private CachePluginResources _resources;

    public StatisticsAndQueryPlanAction(CachePluginResources resources) {
        super(Main.getApplication(), (IResources)resources);
        this._resources = resources;
    }

    public void actionPerformed(ActionEvent e) {
        try {
            if (null == this._sqlPanelAPI) {
                return;
            }
            String sql = this._sqlPanelAPI.getSQLEntryPanel().getSQLToBeExecuted();
            if (StringUtilities.isEmpty((String)sql, (boolean)true)) {
                Main.getApplication().getMessageHandler().showWarningMessage(s_stringMgr.getString("StatisticsAndQueryPlanAction.empty.sql"));
                return;
            }
            IQueryTokenizer queryTokenizer = this._sqlPanelAPI.getSession().getQueryTokenizer();
            queryTokenizer.setScriptToTokenize(sql);
            String cleanedSQL = queryTokenizer.nextQuery().getQuery();
            CustomResultPanel resultPanel = new CustomResultPanel((LayoutManager)new GridLayout(1, 1));
            ImageIcon icon = this._resources.getIcon("intersystems_cac");
            this._sqlPanelAPI.getSQLResultExecuter().addCustomResult(resultPanel, s_stringMgr.getString("StatisticsAndQueryPlanAction.tab.title"), (Icon)icon);
            DataSetTextArea dataSetTextArea = new DataSetTextArea(s_stringMgr.getString("StatisticsAndQueryPlanAction.reading.stats.for.sql", new Object[]{cleanedSQL}));
            JScrollPane scrollPane = new JScrollPane((Component)dataSetTextArea);
            resultPanel.add((Component)scrollPane);
            SwingUtilities.invokeLater(() -> dataSetTextArea.scrollRectToVisible(new Rectangle(0, 0)));
            Connection con = this._sqlPanelAPI.getSession().getSQLConnection().getConnection();
            CacheStatsAndQueryPlanReader readerTask = new CacheStatsAndQueryPlanReader(cleanedSQL, con, dataSetTextArea, scrollPane);
            this._executorService.submit(readerTask);
            resultPanel.setDisposeListener(() -> readerTask.setDisposed());
        }
        catch (Exception ex) {
            Main.getApplication().getMessageHandler().showErrorMessage(s_stringMgr.getString("StatisticsAndQueryPlanAction.failed.to.query.statistics", new Object[]{ex}));
            throw Utilities.wrapRuntime((Throwable)ex);
        }
    }

    public void setSQLPanel(ISQLPanelAPI sqlPanelAPI) {
        this._sqlPanelAPI = sqlPanelAPI;
        this.setEnabled(null != this._sqlPanelAPI);
    }

    public static void main(String[] args) {
        String url = "jdbc:Cache://srv-cache-dev:1972/SHD_MAE_MWE";
        String[] splits = "jdbc:Cache://srv-cache-dev:1972/SHD_MAE_MWE".split("/");
        if (splits.length < 4) {
            throw new IllegalStateException("Expected 4th split(\"/\") of " + url + " to be the Intersystems Cache name space");
        }
        String nameSpace = splits[3];
        System.out.println("nameSpace = " + nameSpace);
    }
}

