/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.cache.tap;

import java.sql.ResultSet;
import java.sql.Statement;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.FormattedSourceTabSimple;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class CacheViewSourceTab
extends FormattedSourceTabSimple {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CacheViewSourceTab.class);
    private static final ILogger s_log = LoggerController.createLogger(CacheViewSourceTab.class);

    public CacheViewSourceTab(ISession session) {
        super(s_stringMgr.getString("CacheViewSourceTab.view.tab.tooltip"), session);
        this.setAppendSeparator(false);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected String getSourceCode(ISession session, IDatabaseObjectInfo databaseObjectInfo) {
        if (databaseObjectInfo.getDatabaseObjectType() != DatabaseObjectType.VIEW) {
            return s_stringMgr.getString("CacheViewSourceTab.cannot.load.sourcecode.for.db.object.type", new Object[]{databaseObjectInfo.getDatabaseObjectType()});
        }
        String sql = "SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS   WHERE TABLE_SCHEMA = '" + databaseObjectInfo.getSchemaName() + "'     AND TABLE_NAME = '" + databaseObjectInfo.getSimpleName() + "' ";
        try (Statement statement = session.getSQLConnection().createStatement();){
            String string;
            block19: {
                ResultSet res;
                block17: {
                    String string2;
                    block18: {
                        res = statement.executeQuery(sql);
                        try {
                            if (res.next()) break block17;
                            String errMsg = s_stringMgr.getString("CacheViewSourceTab.could.not.find.view.source", new Object[]{databaseObjectInfo.getQualifiedName()});
                            s_log.error((Object)errMsg);
                            string2 = errMsg;
                            if (res == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (res != null) {
                                try {
                                    res.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        res.close();
                    }
                    return string2;
                }
                string = res.getString("VIEW_DEFINITION");
                if (res == null) break block19;
                res.close();
            }
            return string;
        }
        catch (Exception e) {
            String errMsg = s_stringMgr.getString("CacheViewSourceTab.failed.to.load.view.source", new Object[]{databaseObjectInfo.getQualifiedName(), e.toString()});
            s_log.error((Object)errMsg, (Throwable)e);
            return errMsg;
        }
    }
}

