/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sessionscript;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.sessionscript.SessionScriptPlugin;
import net.sourceforge.squirrel_sql.plugins.sessionscript.ViewSessionScriptsPanel;

class ScriptsSheet
extends DialogWidget {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ScriptsSheet.class);
    private static ILogger s_log = LoggerController.createLogger(ScriptsSheet.class);
    private static ScriptsSheet s_instance;
    private SessionScriptPlugin _plugin;
    private IApplication _app;
    private ViewSessionScriptsPanel _mainPnl;

    private ScriptsSheet(SessionScriptPlugin plugin, IApplication app) {
        super(s_stringMgr.getString("sessionscript.startupScripts"), true, true, true, true);
        this._plugin = plugin;
        this._app = app;
        this.createUserInterface();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        synchronized (clazz) {
            s_instance = null;
        }
        super.dispose();
    }

    public static synchronized void showSheet(SessionScriptPlugin plugin, IApplication app) {
        if (s_instance == null) {
            s_instance = new ScriptsSheet(plugin, app);
            app.getMainFrame().addWidget((DialogWidget)s_instance);
        }
        s_instance.setVisible(true);
    }

    private void createUserInterface() {
        this.setDefaultCloseOperation(2);
        this.makeToolWindow(true);
        this._mainPnl = new ViewSessionScriptsPanel(this._plugin, this._app);
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        content.add((Component)this._mainPnl, "Center");
        this.setPreferredSize(new Dimension(600, 400));
        this.pack();
    }
}

