/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sessionscript;

import java.io.IOException;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.client.plugin.DefaultSessionPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.plugin.PluginException;
import net.sourceforge.squirrel_sql.client.plugin.PluginResources;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallback;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallbackAdaptor;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.resources.Resources;
import net.sourceforge.squirrel_sql.fw.util.FileWrapper;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.sessionscript.AliasScript;
import net.sourceforge.squirrel_sql.plugins.sessionscript.AliasScriptCache;
import net.sourceforge.squirrel_sql.plugins.sessionscript.SessionScriptResources;
import net.sourceforge.squirrel_sql.plugins.sessionscript.ViewSessionScriptsAction;

public class SessionScriptPlugin
extends DefaultSessionPlugin {
    public static final String BUNDLE_BASE_NAME = "net.sourceforge.squirrel_sql.plugins.sessionscript.sessionscript";
    private static ILogger s_log = LoggerController.createLogger(SessionScriptPlugin.class);
    private FileWrapper _pluginAppFolder;
    private FileWrapper _userSettingsFolder;
    private AliasScriptCache _cache;
    private PluginResources _resources;

    public String getInternalName() {
        return "sessionscript";
    }

    public String getDescriptiveName() {
        return "Session Scripts Plugin";
    }

    public String getVersion() {
        return "0.14";
    }

    public String getAuthor() {
        return "Colin Bell";
    }

    public String getChangeLogFileName() {
        return "changes.txt";
    }

    public String getHelpFileName() {
        return "doc/readme.txt";
    }

    public String getLicenceFileName() {
        return "licence.txt";
    }

    public synchronized void initialize() throws PluginException {
        super.initialize();
        IApplication app = this.getApplication();
        try {
            this._pluginAppFolder = this.getPluginAppSettingsFolder();
        }
        catch (IOException ex) {
            throw new PluginException((Exception)ex);
        }
        try {
            this._userSettingsFolder = this.getPluginUserSettingsFolder();
        }
        catch (IOException ex) {
            throw new PluginException((Exception)ex);
        }
        this._resources = new SessionScriptResources(BUNDLE_BASE_NAME, (IPlugin)this);
        ActionCollection coll = app.getActionCollection();
        ViewSessionScriptsAction action = new ViewSessionScriptsAction(app, (Resources)this._resources, this);
        coll.add((Action)((Object)action));
        app.addToMenu(1, (Action)((Object)action));
        try {
            this._cache = new AliasScriptCache(this);
        }
        catch (IOException ex) {
            throw new PluginException((Exception)ex);
        }
        this._cache.load();
    }

    public void unload() {
        if (this._cache != null) {
            this._cache.save();
        }
        super.unload();
    }

    public PluginSessionCallback sessionStarted(ISession session) {
        String sql;
        boolean rc = false;
        AliasScript script = this._cache.get(session.getAlias());
        if (script != null && (sql = script.getSQL()) != null && sql.length() > 0) {
            rc = true;
            final ISQLPanelAPI api = session.getSessionInternalFrame().getMainSQLPanelAPI();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    api.setEntireSQLScript(sql);
                    api.executeCurrentSQL();
                }
            });
        }
        if (!rc) {
            return null;
        }
        return new PluginSessionCallbackAdaptor();
    }

    public boolean allowsSessionStartedInBackground() {
        return false;
    }

    AliasScriptCache getScriptsCache() {
        return this._cache;
    }
}

