/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sessionscript;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.sessionscript.AliasScript;
import net.sourceforge.squirrel_sql.plugins.sessionscript.SQLALiasesCombo;
import net.sourceforge.squirrel_sql.plugins.sessionscript.SessionScriptPlugin;

public class ViewSessionScriptsPanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ViewSessionScriptsPanel.class);
    private SessionScriptPlugin _plugin;
    private IApplication _app;
    private SQLALiasesCombo _aliasesCmb = new SQLALiasesCombo();
    private JTextArea _sqlEntry = new JTextArea();
    private JButton _saveBtn;

    ViewSessionScriptsPanel(SessionScriptPlugin plugin, IApplication app) {
        if (plugin == null) {
            throw new IllegalArgumentException("SessionScriptPlugin == null");
        }
        if (app == null) {
            throw new IllegalArgumentException("IApplication == null");
        }
        this._plugin = plugin;
        this._app = app;
        this.createUserInterface();
        this.refreshScript();
    }

    private void refreshScript() {
        AliasScript script;
        String sql;
        boolean setText = false;
        SQLAlias alias = this._aliasesCmb.getSelectedSQLAlias();
        if (alias != null && (sql = (script = this._plugin.getScriptsCache().get(alias)).getSQL()) != null && sql.length() > 0) {
            this._sqlEntry.setText(sql);
            setText = true;
        }
        if (!setText) {
            this._sqlEntry.setText("");
        }
        this._saveBtn.setEnabled(false);
    }

    private void createUserInterface() {
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this._aliasesCmb.load(this._app);
        this._aliasesCmb.addActionListener(new AliasesComboListener(this));
        this._sqlEntry.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this._sqlEntry.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent evt) {
                ViewSessionScriptsPanel.this._saveBtn.setEnabled(true);
            }

            @Override
            public void insertUpdate(DocumentEvent evt) {
                ViewSessionScriptsPanel.this._saveBtn.setEnabled(true);
            }

            @Override
            public void removeUpdate(DocumentEvent evt) {
                ViewSessionScriptsPanel.this._saveBtn.setEnabled(true);
            }
        });
        this._saveBtn = new JButton(s_stringMgr.getString("sessionscript.Save"));
        this._saveBtn.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent evt) {
                JTextArea jTextArea = ViewSessionScriptsPanel.this._sqlEntry;
                synchronized (jTextArea) {
                    SQLAlias alias = ViewSessionScriptsPanel.this._aliasesCmb.getSelectedSQLAlias();
                    if (alias != null) {
                        AliasScript script = ViewSessionScriptsPanel.this._plugin.getScriptsCache().get(alias);
                        script.setSQL(ViewSessionScriptsPanel.this._sqlEntry.getText());
                        ViewSessionScriptsPanel.this._saveBtn.setEnabled(false);
                    }
                }
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        this.add((Component)this._aliasesCmb, gbc);
        gbc.fill = 1;
        gbc.weighty = 1.0;
        ++gbc.gridy;
        this.add((Component)new JScrollPane(this._sqlEntry), gbc);
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        ++gbc.gridx;
        this.add((Component)this._saveBtn, gbc);
    }

    private static final class AliasesComboListener
    implements ActionListener {
        private ViewSessionScriptsPanel _pnl;

        AliasesComboListener(ViewSessionScriptsPanel pnl) {
            this._pnl = pnl;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this._pnl.refreshScript();
        }
    }
}

