/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.SybaseASE;

import javax.swing.Action;
import net.sourceforge.squirrel_sql.client.gui.session.ObjectTreeInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SQLInternalFrame;
import net.sourceforge.squirrel_sql.client.plugin.DefaultSessionPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.plugin.PluginException;
import net.sourceforge.squirrel_sql.client.plugin.PluginQueryTokenizerPreferencesManager;
import net.sourceforge.squirrel_sql.client.plugin.PluginResources;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallback;
import net.sourceforge.squirrel_sql.client.plugin.gui.PluginGlobalPreferencesTab;
import net.sourceforge.squirrel_sql.client.plugin.gui.PluginQueryTokenizerPreferencesPanel;
import net.sourceforge.squirrel_sql.client.preferences.IGlobalPreferencesPanel;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreePanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.ITableIndexExtractor;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.ITableTriggerExtractor;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.TableWithChildNodesExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.DatabaseObjectInfoTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.IObjectTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.sqltab.AdditionalSQLTab;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.preferences.IQueryTokenizerPreferenceBean;
import net.sourceforge.squirrel_sql.fw.resources.Resources;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.querytokenizer.IQueryTokenizer;
import net.sourceforge.squirrel_sql.fw.util.ExceptionFormatter;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.SybaseASE.ScriptSybaseASEProcedureAction;
import net.sourceforge.squirrel_sql.plugins.SybaseASE.ScriptSybaseASEViewAction;
import net.sourceforge.squirrel_sql.plugins.SybaseASE.exception.SybaseASEExceptionFormatter;
import net.sourceforge.squirrel_sql.plugins.SybaseASE.exp.SybaseTableIndexExtractorImpl;
import net.sourceforge.squirrel_sql.plugins.SybaseASE.exp.SybaseTableTriggerExtractorImpl;
import net.sourceforge.squirrel_sql.plugins.SybaseASE.prefs.SybasePreferenceBean;
import net.sourceforge.squirrel_sql.plugins.SybaseASE.tab.TriggerSourceTab;
import net.sourceforge.squirrel_sql.plugins.SybaseASE.tab.ViewSourceTab;
import net.sourceforge.squirrel_sql.plugins.SybaseASE.tokenizer.SybaseQueryTokenizer;

public class SybaseASEPlugin
extends DefaultSessionPlugin {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SybaseASEPlugin.class);
    private static final ILogger s_log = LoggerController.createLogger(SybaseASEPlugin.class);
    private PluginResources _resources;
    private PluginQueryTokenizerPreferencesManager _prefsManager = null;
    private static final String SCRIPT_SETTINGS_BORDER_LABEL_DBNAME = "Sybase";

    public String getInternalName() {
        return "sybase";
    }

    public String getDescriptiveName() {
        return "SybaseASE Plugin";
    }

    public String getVersion() {
        return "0.05";
    }

    public String getAuthor() {
        return "Ken McCullough, Guido Wojke";
    }

    public String getChangeLogFileName() {
        return "changes.txt";
    }

    public String getHelpFileName() {
        return "doc/readme.txt";
    }

    public String getLicenceFileName() {
        return "licence.txt";
    }

    public String getContributors() {
        return "";
    }

    public IGlobalPreferencesPanel[] getGlobalPreferencePanels() {
        boolean includeProcSepPref = false;
        PluginQueryTokenizerPreferencesPanel _prefsPanel = new PluginQueryTokenizerPreferencesPanel(this._prefsManager, SCRIPT_SETTINGS_BORDER_LABEL_DBNAME, includeProcSepPref);
        PluginGlobalPreferencesTab tab = new PluginGlobalPreferencesTab(_prefsPanel);
        tab.setHint(i18n.hint);
        tab.setTitle(i18n.title);
        return new IGlobalPreferencesPanel[]{tab};
    }

    private void installSybaseQueryTokenizer(ISession session) {
        IQueryTokenizerPreferenceBean _prefs = this._prefsManager.getPreferences();
        if (_prefs.isInstallCustomQueryTokenizer()) {
            session.setQueryTokenizer((IQueryTokenizer)new SybaseQueryTokenizer(_prefs));
        }
    }

    public synchronized void initialize() throws PluginException {
        this._resources = new PluginResources("net.sourceforge.squirrel_sql.plugins.SybaseASE.SybaseASE", (IPlugin)this);
        this._prefsManager = new PluginQueryTokenizerPreferencesManager();
        this._prefsManager.initialize((IPlugin)this, (IQueryTokenizerPreferenceBean)new SybasePreferenceBean());
    }

    public PluginSessionCallback sessionStarted(ISession session) {
        if (!this.isPluginSession(session)) {
            return null;
        }
        this.installSybaseQueryTokenizer(session);
        String stmtSep = session.getQueryTokenizer().getSQLStatementSeparator();
        SybaseASEExceptionFormatter formatter = new SybaseASEExceptionFormatter();
        session.setExceptionFormatter((ExceptionFormatter)formatter);
        IObjectTreeAPI otApi = session.getSessionInternalFrame().getObjectTreeAPI();
        otApi.addToPopup(DatabaseObjectType.VIEW, (Action)((Object)new ScriptSybaseASEViewAction(this.getApplication(), (Resources)this._resources, session)));
        otApi.addToPopup(DatabaseObjectType.PROCEDURE, (Action)((Object)new ScriptSybaseASEProcedureAction(this.getApplication(), (Resources)this._resources, session)));
        otApi.addDetailTab(DatabaseObjectType.VIEW, (IObjectTab)new ViewSourceTab(i18n.SHOW_VIEW_SOURCE, stmtSep));
        TableWithChildNodesExpander tableExp = new TableWithChildNodesExpander();
        tableExp.setTableIndexExtractor((ITableIndexExtractor)new SybaseTableIndexExtractorImpl());
        tableExp.setTableTriggerExtractor((ITableTriggerExtractor)new SybaseTableTriggerExtractorImpl());
        otApi.addExpander(DatabaseObjectType.TABLE, (INodeExpander)tableExp);
        otApi.addDetailTab(DatabaseObjectType.INDEX, (IObjectTab)new DatabaseObjectInfoTab());
        otApi.addDetailTab(DatabaseObjectType.TRIGGER, (IObjectTab)new DatabaseObjectInfoTab());
        otApi.addDetailTab(DatabaseObjectType.TRIGGER_TYPE_DBO, (IObjectTab)new DatabaseObjectInfoTab());
        otApi.addDetailTab(DatabaseObjectType.TRIGGER, (IObjectTab)new TriggerSourceTab(i18n.TRIGGER_HINT, stmtSep));
        return new PluginSessionCallback(){

            public void sqlInternalFrameOpened(SQLInternalFrame sqlInternalFrame, ISession sess) {
            }

            public void objectTreeInternalFrameOpened(ObjectTreeInternalFrame objectTreeInternalFrame, ISession sess) {
            }

            public void objectTreeInSQLTabOpened(ObjectTreePanel objectTreePanel) {
            }

            public void additionalSQLTabOpened(AdditionalSQLTab additionalSQLTab) {
            }
        };
    }

    protected boolean isPluginSession(ISession session) {
        return DialectFactory.isSyBase((ISQLDatabaseMetaData)session.getMetaData());
    }

    static interface i18n {
        public static final String title = s_stringMgr.getString("SybaseASEPlugin.title");
        public static final String hint = s_stringMgr.getString("SybaseASEPlugin.hint");
        public static final String SHOW_VIEW_SOURCE = s_stringMgr.getString("SybaseASEPlugin.showViewSource");
        public static final String TRIGGER_HINT = s_stringMgr.getString("SybaseASEPlugin.triggerHint");
    }
}

