/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlparam;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.IWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.SelectWidgetCommand;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.event.SQLExecutionAdapter;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.commentandliteral.SQLCommentRemover;
import net.sourceforge.squirrel_sql.fw.sql.querytokenizer.QueryHolder;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.sqlparam.SQLParamPlugin;
import net.sourceforge.squirrel_sql.plugins.sqlparam.gui.AskParamValueDialog;

public class SQLParamExecutionListener
extends SQLExecutionAdapter {
    private static final ILogger s_log = LoggerController.createLogger(SQLParamPlugin.class);
    private SQLParamPlugin _plugin;
    private ISQLPanelAPI _sqlPanelAPI;

    public SQLParamExecutionListener(SQLParamPlugin plugin, ISQLPanelAPI sqlPanelAPI) {
        this._plugin = plugin;
        this._sqlPanelAPI = sqlPanelAPI;
    }

    public void statementExecuted(QueryHolder sql) {
    }

    public String statementExecuting(String sql) {
        String workSql = SQLCommentRemover.removeComments((String)sql);
        StringBuffer buffer = new StringBuffer(workSql);
        Map<String, String> cache = this._plugin.getCache();
        HashMap<String, String> currentCache = new HashMap<String, String>();
        Pattern p = Pattern.compile("[\\ \\(]:[a-zA-Z]\\w+");
        Matcher m = p.matcher(buffer);
        boolean parametersWhereReplaced = false;
        while (m.find()) {
            String value;
            if (this.isQuoted(buffer, m.start())) continue;
            String var = m.group();
            if (currentCache.containsKey(var)) {
                value = (String)currentCache.get(var);
            } else {
                String oldValue = cache.get(var);
                AskParamValueDialog dialog = this.createParameterDialog(var, oldValue);
                if (dialog.isCancelled()) {
                    return null;
                }
                value = this.sanitizeValue(dialog.getValue(), dialog.isQuotingNeeded());
                if (!dialog.isHideText()) {
                    cache.put(var, dialog.getValue());
                    currentCache.put(var, value);
                }
            }
            buffer.replace(m.start(), m.end(), value);
            parametersWhereReplaced = true;
            m.reset();
        }
        GUIUtils.processOnSwingEventThread(() -> new SelectWidgetCommand((IWidget)this._sqlPanelAPI.getSession().getActiveSessionWindow()).execute());
        if (parametersWhereReplaced) {
            return buffer.toString();
        }
        return sql;
    }

    private AskParamValueDialog createParameterDialog(String parameter, String oldValue) {
        AskParamValueDialog dialog = new AskParamValueDialog(this._sqlPanelAPI.getOwningFrame(), parameter, oldValue);
        SwingUtilities.invokeLater(() -> dialog.requestFocusForInputField());
        dialog.setVisible(true);
        return dialog;
    }

    private String sanitizeValue(String value, boolean quoting) {
        Object retValue = value;
        boolean quotesNeeded = quoting;
        try {
            Float.parseFloat(value);
        }
        catch (NumberFormatException nfe) {
            quotesNeeded = true;
        }
        if (quotesNeeded) {
            retValue = "'" + value + "'";
        }
        return retValue;
    }

    private boolean isQuoted(StringBuffer buffer, int position) {
        String part = buffer.substring(0, position);
        if (this.searchAllOccurences(part, "\"") % 2 != 0) {
            return true;
        }
        return this.searchAllOccurences(part, "'") % 2 != 0;
    }

    private int searchAllOccurences(String haystack, String needle) {
        int i = 0;
        int pos = 0;
        while ((pos = haystack.indexOf(needle, pos + 1)) > -1) {
            ++i;
        }
        return i;
    }
}

