/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlparam.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sourceforge.squirrel_sql.client.gui.IOkClosePanelListener;
import net.sourceforge.squirrel_sql.client.gui.OkClosePanel;
import net.sourceforge.squirrel_sql.client.gui.OkClosePanelEvent;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class AskParamValueDialog
extends JDialog {
    private static final StringManager stringMgr = StringManagerFactory.getStringManager(AskParamValueDialog.class);
    private static final String PREF_KEY_ALWAYS_QUOTE_VALUES = "SqlparamPlugin.always.quote.values";
    private OkClosePanel _btnsPnl = new OkClosePanel();
    private JPanel _pnlTxtValueContainer;
    private JTextField _txtValue = new JTextField();
    private JPasswordField _txtHiddenValue = new JPasswordField();
    private JCheckBox _chkQuote = new JCheckBox();
    private JCheckBox _chkQuoteAlways = new JCheckBox();
    private JCheckBox _chkHideValue = new JCheckBox();
    private String _parameter;
    private boolean _done = false;
    private boolean _cancelled = false;

    public AskParamValueDialog(Frame owningFrame, String parameter, String oldValue) {
        super(owningFrame, stringMgr.getString("sqlparam.inputParameterValues"), true);
        this._parameter = parameter;
        this.setContentPane(this.createMainPanel());
        this._txtValue.setText(oldValue);
        this._txtValue.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                AskParamValueDialog.this.updateCheckbox();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AskParamValueDialog.this.updateCheckbox();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AskParamValueDialog.this.updateCheckbox();
            }
        });
        this._chkQuoteAlways.setSelected(Props.getBoolean((String)PREF_KEY_ALWAYS_QUOTE_VALUES, (boolean)false));
        this._chkQuoteAlways.addActionListener(e -> this.onQuoteAlways());
        this._chkHideValue.addActionListener(e -> this.onHideText());
        this.updateCheckbox();
        this._btnsPnl.addListener((IOkClosePanelListener)new MyOkClosePanelListener());
        this._btnsPnl.makeOKButtonDefault();
        this._btnsPnl.getRootPane().setDefaultButton(this._btnsPnl.getOKButton());
        this.pack();
        GUIUtils.centerWithinParent((Window)this);
        GUIUtils.enableCloseByEscape((JDialog)this, d -> {
            this._cancelled = true;
        });
    }

    private void onHideText() {
        this._pnlTxtValueContainer.removeAll();
        if (this._chkHideValue.isSelected()) {
            this._pnlTxtValueContainer.add(this._txtHiddenValue);
        } else {
            this._pnlTxtValueContainer.add(this._txtValue);
        }
        this._pnlTxtValueContainer.invalidate();
        this._pnlTxtValueContainer.doLayout();
        this._pnlTxtValueContainer.repaint();
    }

    private void onQuoteAlways() {
        Props.putBoolean((String)PREF_KEY_ALWAYS_QUOTE_VALUES, (boolean)this._chkQuoteAlways.isSelected());
    }

    public boolean isDone() {
        return this._done;
    }

    public boolean isCancelled() {
        return this._cancelled;
    }

    public void setValue(String defaultValue) {
        this._txtValue.setText(defaultValue);
    }

    public String getValue() {
        if (this._chkHideValue.isSelected()) {
            return String.valueOf(this._txtHiddenValue.getPassword());
        }
        return this._txtValue.getText();
    }

    public boolean isHideText() {
        return this._chkHideValue.isSelected();
    }

    public boolean isQuotingNeeded() {
        return this._chkQuote.isSelected();
    }

    private void updateCheckbox() {
        boolean isNumber;
        try {
            Float.parseFloat(this._txtValue.getText());
            isNumber = true;
        }
        catch (NumberFormatException nfe) {
            isNumber = false;
        }
        if (isNumber) {
            this._chkQuote.setSelected(this._chkQuoteAlways.isSelected());
        } else {
            this._chkQuote.setSelected(true);
        }
    }

    private JPanel createMainPanel() {
        this._txtValue.setColumns(20);
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        panel.add((Component)new JLabel(this.getTitle()), gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        panel.add((Component)new JLabel(stringMgr.getString("sqlparam.valueFor", new Object[]{this._parameter})), gbc);
        gbc = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        this._pnlTxtValueContainer = new JPanel(new GridLayout(1, 1));
        this._pnlTxtValueContainer.add(this._txtValue);
        panel.add((Component)this._pnlTxtValueContainer, gbc);
        gbc = new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        this._chkQuote.setText(stringMgr.getString("sqlparam.quoteValues"));
        panel.add((Component)this._chkQuote, gbc);
        gbc = new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        this._chkQuoteAlways.setText(stringMgr.getString("sqlparam.quoteValues.always"));
        panel.add((Component)this._chkQuoteAlways, gbc);
        gbc = new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        this._chkHideValue.setText(stringMgr.getString("sqlparam.hide.value"));
        panel.add((Component)this._chkHideValue, gbc);
        gbc = new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        panel.add((Component)this._btnsPnl, gbc);
        return panel;
    }

    public void onCancel() {
        this._done = true;
        this._cancelled = true;
        this.setVisible(false);
        this.dispose();
    }

    public void onOk() {
        this._done = true;
        this.setVisible(false);
        this.dispose();
    }

    public void requestFocusForInputField() {
        this._txtValue.requestFocusInWindow();
        this._txtValue.requestFocus();
    }

    private final class MyOkClosePanelListener
    implements IOkClosePanelListener {
        private MyOkClosePanelListener() {
        }

        public void okPressed(OkClosePanelEvent evt) {
            AskParamValueDialog.this.onOk();
        }

        public void closePressed(OkClosePanelEvent evt) {
            AskParamValueDialog.this.onCancel();
        }

        public void cancelPressed(OkClosePanelEvent evt) {
            AskParamValueDialog.this.onCancel();
        }
    }
}

