/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.laf;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.LookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.laf.BaseLAFPreferencesPanelComponent;
import net.sourceforge.squirrel_sql.plugins.laf.DefaultLookAndFeelController;
import net.sourceforge.squirrel_sql.plugins.laf.LAFPlugin;
import net.sourceforge.squirrel_sql.plugins.laf.LAFRegister;
import net.sourceforge.squirrel_sql.plugins.laf.PlasticPrefsPanel;

abstract class AbstractPlasticController
extends DefaultLookAndFeelController {
    private static ILogger s_log = LoggerController.createLogger(AbstractPlasticController.class);
    protected static final String[] PLASTIC_THEME_CLASS_NAMES = new String[]{"com.jgoodies.looks.plastic.theme.BrownSugar", "com.jgoodies.looks.plastic.theme.DarkStar", "com.jgoodies.looks.plastic.theme.DesertBlue", "com.jgoodies.looks.plastic.theme.DesertBluer", "com.jgoodies.looks.plastic.theme.DesertGreen", "com.jgoodies.looks.plastic.theme.DesertRed", "com.jgoodies.looks.plastic.theme.DesertYellow", "com.jgoodies.looks.plastic.theme.ExperienceBlue", "com.jgoodies.looks.plastic.theme.ExperienceGreen", "com.jgoodies.looks.plastic.theme.ExperienceRoyale", "com.jgoodies.looks.plastic.theme.LightGray", "com.jgoodies.looks.plastic.theme.Silver", "com.jgoodies.looks.plastic.theme.SkyBlue", "com.jgoodies.looks.plastic.theme.SkyBluer", "com.jgoodies.looks.plastic.theme.SkyGreen", "com.jgoodies.looks.plastic.theme.SkyKrupp", "com.jgoodies.looks.plastic.theme.SkyPink", "com.jgoodies.looks.plastic.theme.SkyRed", "com.jgoodies.looks.plastic.theme.SkyYellow"};
    public static final String DEFAULT_PLASTIC_THEME_CLASS_NAME = PLASTIC_THEME_CLASS_NAMES[11];
    private final LAFPlugin _lafPlugin;
    private final LAFRegister _lafRegister;
    private Map<String, MetalTheme> _themes = new TreeMap<String, MetalTheme>();
    private PlasticPrefsPanel _plasticPrefsPanel;

    AbstractPlasticController(LAFPlugin plugin, LAFRegister lafRegister) {
        this._lafPlugin = plugin;
        this._lafRegister = lafRegister;
    }

    @Override
    public void initialize() {
        int i;
        this._themes.clear();
        ClassLoader cl = this.getLAFRegister().getLookAndFeelClassLoader();
        MetalTheme[] extras = this.getExtraThemes();
        if (extras == null) {
            extras = new MetalTheme[]{};
        }
        for (i = 0; i < extras.length; ++i) {
            this._themes.put(extras[i].getName(), extras[i]);
        }
        for (i = 0; i < PLASTIC_THEME_CLASS_NAMES.length; ++i) {
            try {
                Class<?> clazz = Class.forName(PLASTIC_THEME_CLASS_NAMES[i], false, cl);
                MetalTheme theme = (MetalTheme)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this._themes.put(theme.getName(), theme);
                continue;
            }
            catch (Throwable th) {
                s_log.error((Object)("Error loading theme " + PLASTIC_THEME_CLASS_NAMES[i]), th);
            }
        }
    }

    @Override
    public void aboutToBeInstalled(LAFRegister lafRegister, LookAndFeel laf) {
        MetalTheme theme;
        String name = this.getCurrentThemeName();
        if (name != null && (theme = this.getThemeForName(name)) != null) {
            try {
                this.installMetalTheme(theme);
            }
            catch (Throwable ex) {
                s_log.error((Object)"Error installing a Theme", ex);
            }
        }
    }

    @Override
    public BaseLAFPreferencesPanelComponent getPreferencesComponent() {
        return this.getPlasticPrefsPanel();
    }

    public final PlasticPrefsPanel getPlasticPrefsPanel() {
        if (null == this._plasticPrefsPanel) {
            this._plasticPrefsPanel = new PlasticPrefsPanel(this);
        }
        return this._plasticPrefsPanel;
    }

    abstract String getCurrentThemeName();

    abstract void setCurrentThemeName(String var1);

    abstract void installMetalTheme(MetalTheme var1);

    MetalTheme getThemeForName(String name) {
        return this._themes.get(name);
    }

    MetalTheme getMetalThemeForClassName(String className) {
        for (MetalTheme metalTheme : this._themes.values()) {
            if (!metalTheme.getClass().getName().equals(className)) continue;
            return metalTheme;
        }
        return null;
    }

    MetalTheme[] getExtraThemes() {
        return new MetalTheme[0];
    }

    LAFRegister getLAFRegister() {
        return this._lafRegister;
    }

    LAFPlugin getLAFPlugin() {
        return this._lafPlugin;
    }

    Iterator<MetalTheme> themesIterator() {
        return this._themes.values().iterator();
    }
}

