/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.laf;

import javax.swing.LookAndFeel;
import javax.swing.plaf.metal.MetalLookAndFeel;
import net.sourceforge.squirrel_sql.fw.util.SquirrelURLClassLoader;
import net.sourceforge.squirrel_sql.fw.util.SystemInfo;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.laf.LAFPreferences;
import org.apache.commons.lang3.StringUtils;

public class LAFLoader {
    private static ILogger s_log = LoggerController.createLogger(LAFLoader.class);

    public static LookAndFeel getLafOrDefaultMetalOnError(LAFPreferences prefs, SquirrelURLClassLoader lafClassLoader) {
        return LAFLoader._getLookAndFeel(prefs.getLookAndFeelClassName(), lafClassLoader, false);
    }

    public static LookAndFeel getLafOrNullOnError(String lafClassName, SquirrelURLClassLoader lafClassLoader) {
        return LAFLoader._getLookAndFeel(lafClassName, lafClassLoader, true);
    }

    private static LookAndFeel _getLookAndFeel(String lookAndFeelClassName, SquirrelURLClassLoader lafClassLoader, boolean silentAndNullable) {
        LookAndFeel laf = new MetalLookAndFeel();
        if (!MetalLookAndFeel.class.getName().equals(lookAndFeelClassName)) {
            try {
                Class<?> lafClass = lafClassLoader != null ? Class.forName(lookAndFeelClassName, true, (ClassLoader)lafClassLoader) : Class.forName(lookAndFeelClassName);
                if (!silentAndNullable && StringUtils.startsWithIgnoreCase((CharSequence)lookAndFeelClassName, (CharSequence)"com.jgoodies") && SystemInfo.isLinux()) {
                    String jgoodiesLinuxMsg = "JGoddies L&F display error: JGoddies Look and Feels on Linux leave tab titles empty at several places. If you are using JGoddies on Linux please consider switching to a Metal or FlatLaf Look and Feel.\nNote: JGoodies does not offer open source updates for its Look and Feels anymore, see: http://www.jgoodies.com/downloads/libraries/";
                    s_log.error((Object)jgoodiesLinuxMsg);
                }
                laf = (LookAndFeel)lafClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable t) {
                if (silentAndNullable) {
                    return null;
                }
                String jgoodiesWindowsLafErr = "superclass access check failed: class com.jgoodies.looks.windows.WindowsLookAndFeel";
                if (StringUtils.containsIgnoreCase((CharSequence)t.toString(), (CharSequence)jgoodiesWindowsLafErr)) {
                    String jgoodiesMsg = "JGoodies WindowsLookAndFeel Java 17 error on MS Windows:\nFailed to load JGoodies WindowsLookAndFeel because it uses an internal com.sun API which from Java 17 on isn't accessible anymore.\nFor a workaround add the Java-VM parameter --add-exports=java.desktop/com.sun.java.swing.plaf.windows=ALL-UNNAMED to your <SquirrelInstallationDir>\\squirrel-sql.bat\nFor details see bug #1507 at SourceForge: https://sourceforge.net/p/squirrel-sql/bugs/1507\nNote that JGoodies does not offer open source updates for its Look and Feels anymore, see: http://www.jgoodies.com/downloads/libraries/\nAlso note: JGoddies Look and Feels on Linux leave tab titles empty at several places. If you are using JGoddies please consider switching to a Metal or FlatLaf Look and Feel.\nDetailed error message:";
                    s_log.error((Object)jgoodiesMsg, t);
                }
                s_log.error((Object)"Failed to load Look and Feel class switching to Metal with Ocean theme.", t);
            }
        }
        return laf;
    }
}

