/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.laf;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import net.sourceforge.squirrel_sql.fw.gui.MultipleLineLabel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.laf.BaseLAFPreferencesPanelComponent;
import net.sourceforge.squirrel_sql.plugins.laf.ILookAndFeelController;
import net.sourceforge.squirrel_sql.plugins.laf.LAFPlugin;
import net.sourceforge.squirrel_sql.plugins.laf.LAFPreferences;
import net.sourceforge.squirrel_sql.plugins.laf.LAFRegister;
import net.sourceforge.squirrel_sql.plugins.laf.LookAndFeelComboBox;

final class LAFPreferencesPanel
extends JPanel {
    StringManager s_stringMgr = StringManagerFactory.getStringManager(LAFPreferencesPanel.class);
    private static ILogger s_log = LoggerController.createLogger(LAFPreferencesPanel.class);
    private LookAndFeelComboBox _lafCmb = new LookAndFeelComboBox();
    private JCheckBox _allowSetBorder = new JCheckBox(this.s_stringMgr.getString("laf.allowsetborder"));
    private LAFPlugin _plugin;
    private LAFRegister _lafRegister;
    private LAFPreferences _prefs;
    private JPanel _lafPnl;
    private JPanel _configHolderPnl = new JPanel(new GridLayout(1, 1));
    private LookAndFeelComboListener _lafComboListener;
    private BaseLAFPreferencesPanelComponent _curLAFConfigComp;

    LAFPreferencesPanel(LAFPlugin plugin, LAFRegister lafRegister) {
        super(new GridBagLayout());
        this._plugin = plugin;
        this._lafRegister = lafRegister;
        this._prefs = this._plugin.getLAFPreferences();
        this.createUserInterface();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._lafComboListener = new LookAndFeelComboListener();
        this._lafCmb.addActionListener(this._lafComboListener);
    }

    @Override
    public void removeNotify() {
        if (this._lafComboListener != null) {
            this._lafCmb.removeActionListener(this._lafComboListener);
            this._lafComboListener = null;
        }
        super.removeNotify();
    }

    void loadData() {
        String selLafClassName = this._prefs.getLookAndFeelClassName();
        this._allowSetBorder.setSelected(this._prefs.getCanLAFSetBorder());
        this._lafCmb.setSelectedLookAndFeelClassName(selLafClassName);
        this.updateLookAndFeelConfigControl();
    }

    void applyChanges() {
        this._prefs.setCanLAFSetBorder(this._allowSetBorder.isSelected());
        this._prefs.setLookAndFeelClassName(this._lafCmb.getSelectedLookAndFeel().getClassName());
        this._lafRegister.applyPreferences();
        boolean forceChange = false;
        if (this._curLAFConfigComp != null) {
            forceChange = this._curLAFConfigComp.applyChanges();
        }
        try {
            this._lafRegister.setLookAndFeel(forceChange);
        }
        catch (Exception ex) {
            s_log.error((Object)"Error setting Look and Feel", (Throwable)ex);
        }
    }

    private void createUserInterface() {
        this._lafPnl = this.createLookAndFeelPanel();
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(4, 4, 4, 4), 0, 0);
        this.add((Component)this._lafPnl, gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(4, 4, 4, 4), 0, 0);
        this.add((Component)new MultipleLineLabel(LAFPreferencesPanelI18n.LAF_WARNING), gbc);
        gbc = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(4, 4, 4, 4), 0, 0);
        MultipleLineLabel enforedWarningLabel = new MultipleLineLabel(LAFPreferencesPanelI18n.LAF_CRITICAL_WARNING);
        enforedWarningLabel.setForeground(Color.red);
        this.add((Component)enforedWarningLabel, gbc);
        gbc = new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(4, 4, 4, 4), 0, 0);
        this.add((Component)new JPanel(), gbc);
    }

    private JPanel createLookAndFeelPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        ret.setBorder(BorderFactory.createTitledBorder(this.s_stringMgr.getString("laf.broderLaf")));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0);
        ret.add((Component)new JLabel(LAFPreferencesPanelI18n.LOOK_AND_FEEL, 4), gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0);
        ret.add((Component)this._lafCmb, gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0);
        ret.add((Component)new JLabel(LAFPreferencesPanelI18n.LAF_LOC, 4), gbc);
        gbc = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(4, 4, 4, 4), 0, 0);
        ret.add((Component)new MultipleLineLabel(this._plugin.getLookAndFeelFolder().getAbsolutePath()), gbc);
        gbc = new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(4, 0, 4, 4), 0, 0);
        ret.add((Component)this._configHolderPnl, gbc);
        return ret;
    }

    private JPanel createSettingsPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.setBorder(BorderFactory.createTitledBorder(this.s_stringMgr.getString("laf.general")));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        pnl.add((Component)this._allowSetBorder, gbc);
        return pnl;
    }

    private void updateLookAndFeelConfigControl() {
        ILookAndFeelController ctrl;
        String selLafClassName;
        UIManager.LookAndFeelInfo lafInfo;
        if (this._curLAFConfigComp != null) {
            this._configHolderPnl.remove(this._curLAFConfigComp);
            this._curLAFConfigComp = null;
        }
        if ((lafInfo = this._lafCmb.getSelectedLookAndFeel()) != null && (selLafClassName = lafInfo.getClassName()) != null && (ctrl = this._lafRegister.getLookAndFeelController(selLafClassName)) != null) {
            this._curLAFConfigComp = ctrl.getPreferencesComponent();
            if (this._curLAFConfigComp != null) {
                this._curLAFConfigComp.loadPreferencesPanel();
                this._configHolderPnl.add(this._curLAFConfigComp);
            }
        }
        this.validate();
    }

    private class LookAndFeelComboListener
    implements ActionListener {
        private LookAndFeelComboListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            LAFPreferencesPanel.this.updateLookAndFeelConfigControl();
        }
    }

    static interface LAFPreferencesPanelI18n {
        public static final StringManager s_stringMgr = StringManagerFactory.getStringManager(LAFPreferencesPanelI18n.class);
        public static final String LOOK_AND_FEEL = s_stringMgr.getString("laf.lookAndFeel");
        public static final String LAF_WARNING = s_stringMgr.getString("laf.lafWarning");
        public static final String TAB_TITLE = s_stringMgr.getString("laf.lf");
        public static final String TAB_HINT = s_stringMgr.getString("laf.settings");
        public static final String LAF_LOC = s_stringMgr.getString("laf.jars");
        public static final String LAF_CRITICAL_WARNING = s_stringMgr.getString("laf.lafCriticalWarning");
    }
}

