/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.laf;

import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.UIManager;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.laf.AbstractPlasticController;
import net.sourceforge.squirrel_sql.plugins.laf.LAFPlugin;
import net.sourceforge.squirrel_sql.plugins.laf.LAFRegister;
import net.sourceforge.squirrel_sql.plugins.laf.MetalThemePreferencesUtil;
import net.sourceforge.squirrel_sql.plugins.laf.ThemePreferences;

public class MetalLookAndFeelController
extends AbstractPlasticController {
    private static ILogger s_log = LoggerController.createLogger(MetalLookAndFeelController.class);
    public static final String METAL_LAF_CLASS_NAME = MetalLookAndFeel.class.getName();
    private String[] _extraThemeClassNames = new String[0];
    private MetalThemePreferences _currentThemePrefs;
    private MetalTheme _defaultMetalTheme;
    private HashMap<String, MetalTheme> _themesByName = new HashMap();

    MetalLookAndFeelController(LAFPlugin plugin, LAFRegister lafRegister) {
        super(plugin, lafRegister);
        this._extraThemeClassNames = new String[]{"javax.swing.plaf.metal.OceanTheme", "AquaTheme", "CharcoalTheme", "ContrastTheme", "EmeraldTheme", "RubyTheme", "net.sourceforge.squirrel_sql.client.gui.laf.AllBluesBoldMetalTheme"};
        this._defaultMetalTheme = new DefaultMetalTheme();
        this._currentThemePrefs = MetalThemePreferencesUtil.getMetalThemePreferences(plugin, this.getLAFRegister());
    }

    @Override
    MetalTheme[] getExtraThemes() {
        ClassLoader cl = this.getLAFRegister().getLookAndFeelClassLoader();
        ArrayList<MetalTheme> ret = new ArrayList<MetalTheme>();
        boolean defaultThemeIsIncluded = false;
        for (int i = 0; i < this._extraThemeClassNames.length; ++i) {
            try {
                Class<?> clazz = Class.forName(this._extraThemeClassNames[i], false, cl);
                MetalTheme metalTheme = (MetalTheme)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this._themesByName.put(metalTheme.getName(), metalTheme);
                ret.add(metalTheme);
                if (null == this._defaultMetalTheme || !this._extraThemeClassNames[i].equals(this._defaultMetalTheme.getClass().getName())) continue;
                defaultThemeIsIncluded = true;
                continue;
            }
            catch (Throwable th) {
                s_log.error((Object)("Error loading theme " + this._extraThemeClassNames[i]), th);
            }
        }
        if (!defaultThemeIsIncluded) {
            ret.add(this._defaultMetalTheme);
        }
        return ret.toArray(new MetalTheme[ret.size()]);
    }

    @Override
    MetalTheme getThemeForName(String name) {
        MetalTheme ret = super.getThemeForName(name);
        if (null == ret) {
            ret = this._themesByName.get(name);
        }
        return ret;
    }

    @Override
    void installMetalTheme(MetalTheme theme) {
        UIManager.put("swing.boldMetal", Boolean.FALSE);
        MetalLookAndFeel.setCurrentTheme(theme);
    }

    @Override
    String getCurrentThemeName() {
        return this._currentThemePrefs.getThemeName();
    }

    @Override
    void setCurrentThemeName(String name) {
        this._currentThemePrefs.setThemeName(name);
    }

    public void applyTheme(String metalThemeClassName) {
        MetalTheme theme = super.getMetalThemeForClassName(metalThemeClassName);
        this._currentThemePrefs.setThemeName(theme.getName());
        this.getPlasticPrefsPanel().loadPreferencesPanel();
        this.installMetalTheme(theme);
    }

    public static final class MetalThemePreferences
    extends ThemePreferences {
    }
}

