/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.laf;

import java.util.Iterator;
import javax.swing.plaf.metal.MetalTheme;
import net.sourceforge.squirrel_sql.fw.id.IHasIdentifier;
import net.sourceforge.squirrel_sql.fw.util.DuplicateObjectException;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.fw.xml.XMLObjectCache;
import net.sourceforge.squirrel_sql.plugins.laf.LAFPlugin;
import net.sourceforge.squirrel_sql.plugins.laf.LAFPreferences;
import net.sourceforge.squirrel_sql.plugins.laf.LAFRegister;
import net.sourceforge.squirrel_sql.plugins.laf.MetalLookAndFeelController;

public class MetalThemePreferencesUtil {
    private static ILogger s_log = LoggerController.createLogger(MetalThemePreferencesUtil.class);
    public static final String DEFAULT_METAL_THEME_CLASS_NAME = "javax.swing.plaf.metal.OceanTheme";
    public static final String CHARCOAL_THEME_CLASS_NAME = "CharcoalTheme";

    public static MetalLookAndFeelController.MetalThemePreferences getMetalThemePreferences(LAFPlugin plugin, LAFRegister lafRegister) {
        try {
            MetalLookAndFeelController.MetalThemePreferences ret;
            XMLObjectCache<LAFPreferences> cache = plugin.getSettingsCache();
            Iterator it = cache.getAllForClass(MetalLookAndFeelController.MetalThemePreferences.class);
            if (it.hasNext()) {
                ret = (MetalLookAndFeelController.MetalThemePreferences)it.next();
            } else {
                ret = new MetalLookAndFeelController.MetalThemePreferences();
                ClassLoader cl = lafRegister.getLookAndFeelClassLoader();
                Class<?> clazz = Class.forName(DEFAULT_METAL_THEME_CLASS_NAME, false, cl);
                MetalTheme theme = (MetalTheme)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                ret.setThemeName(theme.getName());
                try {
                    cache.add((IHasIdentifier)ret);
                }
                catch (DuplicateObjectException ex) {
                    s_log.error((Object)"MetalThemePreferences object already in XMLObjectCache", (Throwable)ex);
                }
            }
            return ret;
        }
        catch (Exception e) {
            throw Utilities.wrapRuntime((Throwable)e);
        }
    }
}

