/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.laf;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public abstract class PlaceholderLookAndFeel
extends LookAndFeel {
    private static Map<Class<? extends LookAndFeel>, UIManager.LookAndFeelInfo> infos = new ConcurrentHashMap<Class<? extends LookAndFeel>, UIManager.LookAndFeelInfo>();

    protected PlaceholderLookAndFeel(String name) {
        infos.computeIfAbsent(this.getClass(), k -> new UIManager.LookAndFeelInfo(name, k.getName()));
    }

    public static Collection<UIManager.LookAndFeelInfo> getInfos() {
        return Collections.unmodifiableCollection(infos.values());
    }

    public static boolean isPlaceholder(String className) {
        for (Class<? extends LookAndFeel> klass : infos.keySet()) {
            if (!klass.getName().equals(className)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return infos.get(this.getClass()).getName();
    }

    @Override
    public String getID() {
        return this.getName();
    }

    @Override
    public String getDescription() {
        return this.getName();
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return false;
    }

    public UIManager.LookAndFeelInfo getLookAndFeelInfo() {
        return infos.get(this.getClass());
    }
}

