/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.laf;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.plaf.metal.MetalTheme;
import net.sourceforge.squirrel_sql.plugins.laf.AbstractPlasticController;
import net.sourceforge.squirrel_sql.plugins.laf.BaseLAFPreferencesPanelComponent;

final class PlasticPrefsPanel
extends BaseLAFPreferencesPanelComponent {
    private AbstractPlasticController _ctrl;
    private JComboBox _themeCmb;
    private int _origSelThemeIdx;

    PlasticPrefsPanel(AbstractPlasticController ctrl) {
        this._ctrl = ctrl;
        this.createUserInterface();
    }

    private void createUserInterface() {
        this.setLayout(new GridBagLayout());
        this._themeCmb = new JComboBox();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)new JLabel("Theme:", 4), gbc);
        ++gbc.gridx;
        this.add((Component)this._themeCmb, gbc);
    }

    @Override
    public void loadPreferencesPanel() {
        super.loadPreferencesPanel();
        this.loadThemesCombo();
    }

    @Override
    public boolean applyChanges() {
        super.applyChanges();
        if (this._origSelThemeIdx != this._themeCmb.getSelectedIndex()) {
            this._ctrl.setCurrentThemeName((String)this._themeCmb.getSelectedItem());
            return true;
        }
        return false;
    }

    private void loadThemesCombo() {
        this._themeCmb.removeAllItems();
        Iterator<MetalTheme> it = this._ctrl.themesIterator();
        while (it.hasNext()) {
            this._themeCmb.addItem(it.next().getName());
        }
        if (this._themeCmb.getModel().getSize() > 0) {
            String selThemeName = this._ctrl.getCurrentThemeName();
            if (selThemeName != null && selThemeName.length() > 0) {
                this._themeCmb.setSelectedItem(selThemeName);
            }
            if (this._themeCmb.getSelectedIndex() == -1) {
                this._themeCmb.setSelectedIndex(0);
            }
        }
        this._origSelThemeIdx = this._themeCmb.getSelectedIndex();
    }
}

