/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.laf;

import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class RadianceLafData {
    private static ILogger s_log = LoggerController.createLogger(RadianceLafData.class);
    private HashMap<String, Class<?>> lafMap = new HashMap();
    private ClassLoader cl = null;

    public RadianceLafData(ClassLoader cl) {
        this.cl = cl;
        this.initLafMap();
    }

    private void initLafMap() {
        this.putClass("Business", "org.pushingpixels.radiance.theming.api.skin.RadianceBusinessLookAndFeel");
        this.putClass("BusinessBlackSteel", "org.pushingpixels.radiance.theming.api.skin.RadianceBusinessBlackSteelLookAndFeel");
        this.putClass("BusinessBlueSteelSkin", "org.pushingpixels.radiance.theming.api.skin.RadianceBusinessBlueSteelLookAndFeel");
        this.putClass("Creme", "org.pushingpixels.radiance.theming.api.skin.RadianceCremeLookAndFeel");
        this.putClass("CremeCoffee", "org.pushingpixels.radiance.theming.api.skin.RadianceCremeCoffeeLookAndFeel");
        this.putClass("Sahara", "org.pushingpixels.radiance.theming.api.skin.RadianceSaharaLookAndFeel");
        this.putClass("Moderate", "org.pushingpixels.radiance.theming.api.skin.RadianceModerateLookAndFeel");
        this.putClass("Nebula", "org.pushingpixels.radiance.theming.api.skin.RadianceNebulaLookAndFeel");
        this.putClass("NebulaAmethyst", "org.pushingpixels.radiance.theming.api.skin.RadianceNebulaAmethystLookAndFeel");
        this.putClass("NebulaBrickWall", "org.pushingpixels.radiance.theming.api.skin.RadianceNebulaBrickWallLookAndFeel");
        this.putClass("Autumn", "org.pushingpixels.radiance.theming.api.skin.RadianceAutumnLookAndFeel");
        this.putClass("MistSilver", "org.pushingpixels.radiance.theming.api.skin.RadianceMistSilverLookAndFeel");
        this.putClass("MistAqua", "org.pushingpixels.radiance.theming.api.skin.RadianceMistAquaLookAndFeel");
        this.putClass("Dust", "org.pushingpixels.radiance.theming.api.skin.RadianceDustLookAndFeel");
        this.putClass("DustCoffee", "org.pushingpixels.radiance.theming.api.skin.RadianceDustCoffeeLookAndFeel");
        this.putClass("Gemini", "org.pushingpixels.radiance.theming.api.skin.RadianceGeminiLookAndFeel");
        this.putClass("Mariner", "org.pushingpixels.radiance.theming.api.skin.RadianceMarinerLookAndFeel");
        this.putClass("Sentinel", "org.pushingpixels.radiance.theming.api.skin.RadianceSentinelLookAndFeel");
        this.putClass("Cerulean", "org.pushingpixels.radiance.theming.api.skin.RadianceCeruleanLookAndFeel");
        this.putClass("GreenMagic", "org.pushingpixels.radiance.theming.api.skin.RadianceGreenMagicLookAndFeel");
        this.putClass("OfficeSilver2007", "org.pushingpixels.radiance.theming.extras.api.skinpack.RadianceOfficeSilver2007LookAndFeel");
        this.putClass("OfficeBlue2007", "org.pushingpixels.radiance.theming.extras.api.skinpack.RadianceOfficeBlue2007LookAndFeel");
        this.putClass("OfficeBlack2007", "org.pushingpixels.radiance.theming.extras.api.skinpack.RadianceOfficeBlack2007LookAndFeel");
    }

    public Class<?> getSkinClassForName(String skinName) {
        return this.lafMap.get(skinName);
    }

    public Set<String> getRadianceSkins() {
        TreeSet<String> result = new TreeSet<String>(this.lafMap.keySet());
        return result;
    }

    private void putClass(String skinName, String className) {
        try {
            Class<?> skinClass = Class.forName(className, true, this.cl);
            this.lafMap.put(skinName, skinClass);
        }
        catch (ClassNotFoundException e) {
            s_log.error((Object)("Unable to load LAF class (" + className + "):" + e.getMessage()), (Throwable)e);
        }
    }
}

