/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.laf.flatlaf;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import net.sourceforge.squirrel_sql.fw.id.IHasIdentifier;
import net.sourceforge.squirrel_sql.fw.util.DuplicateObjectException;
import net.sourceforge.squirrel_sql.fw.util.FileWrapper;
import net.sourceforge.squirrel_sql.fw.util.SquirrelLookAndFeelHandler;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.fw.xml.XMLObjectCache;
import net.sourceforge.squirrel_sql.plugins.laf.BaseLAFPreferencesPanelComponent;
import net.sourceforge.squirrel_sql.plugins.laf.DefaultLookAndFeelController;
import net.sourceforge.squirrel_sql.plugins.laf.LAFPlugin;
import net.sourceforge.squirrel_sql.plugins.laf.LAFPreferences;
import net.sourceforge.squirrel_sql.plugins.laf.LAFRegister;
import net.sourceforge.squirrel_sql.plugins.laf.flatlaf.FlatLafPlaceholder;
import net.sourceforge.squirrel_sql.plugins.laf.flatlaf.FlatLafProxy;
import net.sourceforge.squirrel_sql.plugins.laf.flatlaf.FlatThemePreference;

public class FlatLookAndFeelController
extends DefaultLookAndFeelController {
    private static final ILogger s_log = LoggerController.createLogger(FlatLookAndFeelController.class);
    public static final String FLAT_LAF_PLACEHOLDER_CLASS_NAME = new FlatLafPlaceholder().getClass().getName();
    private FlatThemePreference selectedTheme;
    private Map<String, Object> availableThemes;
    private FileWrapper userExtraLAFFolder;
    private FlatLafProxy flatProxy;
    private ThemePrefsPanel _themePrefsPanel;

    public FlatLookAndFeelController(LAFPlugin plugin, LAFRegister register) {
        this.flatProxy = new FlatLafProxy(register.getLookAndFeelClassLoader());
        this.userExtraLAFFolder = plugin.getUsersExtraLAFFolder();
        XMLObjectCache<LAFPreferences> cache = plugin.getSettingsCache();
        Iterator it = cache.getAllForClass(FlatThemePreference.class);
        if (it.hasNext()) {
            this.selectedTheme = (FlatThemePreference)it.next();
        } else {
            this.selectedTheme = new FlatThemePreference();
            try {
                cache.add((IHasIdentifier)this.selectedTheme);
            }
            catch (DuplicateObjectException e) {
                s_log.warn((Object)"FlatTheme object already in XMLObjectCache", (Throwable)e);
            }
        }
    }

    Map<String, Object> getAvailableThemes() {
        if (this.availableThemes == null) {
            LinkedHashMap<String, Object> themes = new LinkedHashMap<String, Object>();
            themes.putAll(this.flatProxy.getStandardThemes());
            themes.putAll(this.loadUserThemes());
            this.availableThemes = themes;
        }
        return this.availableThemes;
    }

    private Map<String, ?> loadUserThemes() {
        TreeMap<String, Object> themes = new TreeMap<String, Object>();
        for (FileWrapper json : this.userExtraLAFFolder.listFiles((dir, name) -> name.endsWith(".theme.json"))) {
            try (FileInputStream in = json.getFileInputStream();){
                Object theme = this.flatProxy.createIntelliJTheme(in);
                themes.put(this.flatProxy.getIntelliJThemeName(theme), theme);
            }
            catch (IOException e) {
                s_log.error((Object)("Could not read: " + json.getAbsolutePath()), (Throwable)e);
            }
        }
        for (FileWrapper props : this.userExtraLAFFolder.listFiles((dir, name) -> name.endsWith(".properties"))) {
            if (props.getName().equals("extralafs.properties")) {
                s_log.debug((Object)"FlatLaf theme: extralafs.properties skipped");
                continue;
            }
            Properties theme = new Properties();
            try (FileInputStream in = props.getFileInputStream();){
                theme.load(in);
                if (theme.getProperty("@baseTheme") == null) {
                    s_log.info((Object)("Properties file doesn't appear to be a FlatLaf theme: " + props));
                    continue;
                }
                themes.put(props.getName().replaceFirst(".properties$", ""), theme);
            }
            catch (IOException e) {
                s_log.error((Object)("Could not read: " + props.getAbsolutePath()), (Throwable)e);
            }
        }
        return themes;
    }

    @Override
    public void hasBeenInstalled(LAFRegister lafRegister, LookAndFeel laf) {
        this._hasBeenInstalled();
    }

    private void _hasBeenInstalled() {
        Object theme = this.getAvailableThemes().get(this.selectedTheme.getName());
        try {
            if (null == theme && 0 < this.getAvailableThemes().size()) {
                s_log.error((Object)("Flat-Laf theme \"" + this.selectedTheme.getName() + "\" is not in available themes."));
                theme = this.getAvailableThemes().values().iterator().next();
            }
            LookAndFeel lnf = theme instanceof Class ? (LookAndFeel)((Class)theme).getConstructor(new Class[0]).newInstance(new Object[0]) : (theme instanceof Properties ? this.flatProxy.createPropsLaf(this.selectedTheme.getName(), (Properties)theme) : this.flatProxy.createLaf(theme));
            UIManager.put("ClassLoader", lnf.getClass().getClassLoader());
            SquirrelLookAndFeelHandler.setLookAndFeel((LookAndFeel)lnf);
        }
        catch (Exception e) {
            s_log.error((Object)("Problem setting look and feel: " + theme), (Throwable)e);
        }
    }

    @Override
    public BaseLAFPreferencesPanelComponent getPreferencesComponent() {
        return this.getThemePrefsPanel();
    }

    private ThemePrefsPanel getThemePrefsPanel() {
        if (null == this._themePrefsPanel) {
            this.availableThemes = null;
            this._themePrefsPanel = new ThemePrefsPanel(this);
        }
        return this._themePrefsPanel;
    }

    public void applyTheme(String flatLafThemeName) {
        for (Map.Entry<String, Class<? extends LookAndFeel>> entry : this.flatProxy.getStandardThemes().entrySet()) {
            if (!entry.getKey().equals(flatLafThemeName)) continue;
            this.selectedTheme.setName(entry.getKey());
            this.getThemePrefsPanel().loadPreferencesPanel();
            this._hasBeenInstalled();
            break;
        }
    }

    private static class ThemePrefsPanel
    extends BaseLAFPreferencesPanelComponent {
        private FlatLookAndFeelController ctrl;
        private JComboBox<String> themeList;

        ThemePrefsPanel(FlatLookAndFeelController ctrl) {
            this.ctrl = ctrl;
            this.initUI();
        }

        private void initUI() {
            this.setLayout(new BoxLayout(this, 2));
            this.themeList = new JComboBox();
            JLabel label = new JLabel("Theme:");
            label.setLabelFor(this.themeList);
            this.add(label);
            this.add(Box.createHorizontalStrut(5));
            this.add(this.themeList);
        }

        @Override
        public void loadPreferencesPanel() {
            DefaultComboBoxModel<String> items = new DefaultComboBoxModel<String>();
            for (String name : this.ctrl.getAvailableThemes().keySet()) {
                items.addElement(name);
            }
            items.setSelectedItem(this.ctrl.selectedTheme.getName());
            this.themeList.setModel(items);
        }

        @Override
        public boolean applyChanges() {
            if (null != this.themeList.getSelectedItem() && !StringUtilities.isEmpty((String)this.themeList.getSelectedItem().toString(), (boolean)true)) {
                this.ctrl.selectedTheme.setName(this.themeList.getSelectedItem().toString());
            }
            return true;
        }
    }
}

