/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.laf.nimbus;

import java.awt.Color;
import java.awt.Window;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.nimbus.NimbusLookAndFeel;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.laf.nimbus.NimbusLookAndFeelController;

public class NimbusDarkTheme {
    private static final ILogger s_log = LoggerController.createLogger(NimbusLookAndFeelController.class);

    public static void configDarkTheme() {
        if (UIManager.getLookAndFeel() instanceof NimbusLookAndFeel) {
            NimbusDarkTheme.configColor("control", Color.gray);
            NimbusDarkTheme.configColor("info", Color.gray);
            NimbusDarkTheme.configColor("nimbusBase", new Color(18, 30, 49));
            NimbusDarkTheme.configColor("nimbusAlertYellow", new Color(248, 187, 0));
            NimbusDarkTheme.configColor("nimbusDisabledText", new Color(100, 100, 100));
            NimbusDarkTheme.configColor("nimbusFocus", new Color(115, 164, 209));
            NimbusDarkTheme.configColor("nimbusGreen", new Color(176, 179, 50));
            NimbusDarkTheme.configColor("nimbusInfoBlue", new Color(66, 139, 221));
            NimbusDarkTheme.configColor("nimbusLightBackground", new Color(18, 30, 49));
            NimbusDarkTheme.configColor("nimbusOrange", new Color(191, 98, 4));
            NimbusDarkTheme.configColor("nimbusRed", new Color(169, 46, 34));
            NimbusDarkTheme.configColor("nimbusSelectedText", Color.white);
            NimbusDarkTheme.configColor("nimbusSelectionBackground", new Color(104, 93, 156));
            NimbusDarkTheme.configColor("text", new Color(230, 230, 230));
            NimbusDarkTheme.configColor("Tree.foreground", new Color(255, 255, 255));
            try {
                NimbusDarkTheme.configTreeIcon();
            }
            catch (Exception e) {
                s_log.error((Object)"Failed to load JTree icons from Java's standard location", (Throwable)e);
            }
        }
    }

    private static void configColor(String key, Color defaultValue) {
        Color color = defaultValue;
        String systemPropertyColor = System.getProperty(key);
        if (systemPropertyColor != null && !systemPropertyColor.isEmpty()) {
            try {
                color = NimbusDarkTheme.buildColor(systemPropertyColor);
            }
            catch (Exception e) {
                s_log.error((Object)"Failed to build colors. Default colors will be used", (Throwable)e);
            }
        }
        UIManager.put(key, color);
    }

    private static Color buildColor(String colorValue) {
        String[] rgb;
        if (colorValue == null || colorValue.isEmpty()) {
            throw new RuntimeException("Color value empty");
        }
        String cv = colorValue.trim();
        if (cv.startsWith("(")) {
            cv = cv.substring(1).trim();
        }
        if (cv.endsWith(")")) {
            cv = cv.substring(0, cv.length() - 1).trim();
        }
        if ((rgb = cv.split(",")).length != 3) {
            throw new RuntimeException("Color (" + colorValue + ") format error");
        }
        return new Color(Integer.valueOf(rgb[0].trim()), Integer.valueOf(rgb[1].trim()), Integer.valueOf(rgb[2].trim()));
    }

    public static void resetDefaultTheme(Window window) {
        if (UIManager.getLookAndFeel() instanceof NimbusLookAndFeel) {
            SwingUtilities.invokeLater(() -> {
                UIManager.getDefaults().putAll(UIManager.getLookAndFeel().getDefaults());
                SwingUtilities.updateComponentTreeUI(window);
            });
        }
    }

    private static void configTreeIcon() {
        UIManager.getDefaults().remove("Tree.collapsedIcon");
        UIManager.getDefaults().remove("Tree.expandedIcon");
        UIManager.put("Tree.collapsedIcon", NimbusDarkTheme.loadImage("close.gif"));
        UIManager.put("Tree.expandedIcon", NimbusDarkTheme.loadImage("open.gif"));
    }

    private static ImageIcon loadImage(String file) {
        URL fileUrl = NimbusDarkTheme.class.getResource(file);
        return new ImageIcon(fileUrl);
    }
}

