/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.laf.nimbus;

import java.awt.Window;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.nimbus.NimbusLookAndFeel;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.SquirrelLookAndFeelHandler;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.laf.BaseLAFPreferencesPanelComponent;
import net.sourceforge.squirrel_sql.plugins.laf.DefaultLookAndFeelController;
import net.sourceforge.squirrel_sql.plugins.laf.LAFPlugin;
import net.sourceforge.squirrel_sql.plugins.laf.LAFRegister;
import net.sourceforge.squirrel_sql.plugins.laf.nimbus.NimbusDarkTheme;
import net.sourceforge.squirrel_sql.plugins.laf.nimbus.NimbusThemeEnum;

public class NimbusLookAndFeelController
extends DefaultLookAndFeelController {
    public static final String NIMBUS_LAF_CLASS_NAME = NimbusLookAndFeel.class.getName();
    private static final String PREF_KEY_NIMBUS_THEME = "lafplugin.NimbusLookAndFeelController.PREF_KEY_NIMBUS_THEME";
    private static final ILogger s_log = LoggerController.createLogger(NimbusLookAndFeelController.class);
    private ThemePrefsPanel _themePrefsPanel;

    public NimbusLookAndFeelController(LAFPlugin plugin, LAFRegister register) {
    }

    private static NimbusThemeEnum getSelectedTheme() {
        String nimbusThemeName = Props.getString((String)PREF_KEY_NIMBUS_THEME, (String)NimbusThemeEnum.NIMBUS_DEFAULT.name());
        return NimbusThemeEnum.valueOf(nimbusThemeName);
    }

    private static void setSelectedTheme(NimbusThemeEnum selectedTheme) {
        Props.putString((String)PREF_KEY_NIMBUS_THEME, (String)selectedTheme.name());
    }

    @Override
    public void hasBeenInstalled(LAFRegister lafRegister, LookAndFeel laf) {
        this._hasBeenInstalled();
    }

    private void _hasBeenInstalled() {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                SquirrelLookAndFeelHandler.setLookAndFeel((String)info.getClassName());
                if (NimbusLookAndFeelController.getSelectedTheme() == NimbusThemeEnum.NIMBUS_DARK) {
                    NimbusDarkTheme.configDarkTheme();
                } else {
                    NimbusDarkTheme.resetDefaultTheme((Window)Main.getApplication().getMainFrame());
                }
                break;
            }
        }
        catch (Exception e) {
            s_log.error((Object)"Failed to load Nimbus look and feel", (Throwable)e);
        }
    }

    @Override
    public BaseLAFPreferencesPanelComponent getPreferencesComponent() {
        return this.getThemePrefsPanel();
    }

    private ThemePrefsPanel getThemePrefsPanel() {
        if (null == this._themePrefsPanel) {
            this._themePrefsPanel = new ThemePrefsPanel();
        }
        return this._themePrefsPanel;
    }

    private static class ThemePrefsPanel
    extends BaseLAFPreferencesPanelComponent {
        private JComboBox<NimbusThemeEnum> themeList;

        ThemePrefsPanel() {
            this.initUI();
        }

        private void initUI() {
            this.setLayout(new BoxLayout(this, 2));
            this.themeList = new JComboBox();
            JLabel label = new JLabel("Theme:");
            label.setLabelFor(this.themeList);
            this.add(label);
            this.add(Box.createHorizontalStrut(5));
            this.add(this.themeList);
        }

        @Override
        public void loadPreferencesPanel() {
            DefaultComboBoxModel<NimbusThemeEnum> items = new DefaultComboBoxModel<NimbusThemeEnum>();
            for (NimbusThemeEnum theme : NimbusThemeEnum.values()) {
                items.addElement(theme);
            }
            items.setSelectedItem((Object)NimbusLookAndFeelController.getSelectedTheme());
            this.themeList.setModel(items);
        }

        @Override
        public boolean applyChanges() {
            if (null != this.themeList.getSelectedItem()) {
                NimbusLookAndFeelController.setSelectedTheme((NimbusThemeEnum)((Object)this.themeList.getSelectedItem()));
            }
            return true;
        }
    }
}

