/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.codecompletion;

import net.sourceforge.squirrel_sql.fw.completion.util.CompletionParser;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.plugins.codecompletion.CodeCompletionInfo;
import net.sourceforge.squirrel_sql.plugins.codecompletion.CompletionCaseSpelling;
import net.sourceforge.squirrel_sql.plugins.codecompletion.prefs.CodeCompletionPreferences;

public class CodeCompletionColumnInfo
extends CodeCompletionInfo {
    private String _tableName;
    private String _columnName;
    private String _columnType;
    private int _columnSize;
    private boolean _nullable;
    private CodeCompletionPreferences _prefs;
    private String _toString;
    private int _decimalDigits;
    private String _remarks;

    public CodeCompletionColumnInfo(String tableName, String columnName, String remarks, String columnType, int columnSize, int decimalDigits, boolean nullable, CodeCompletionPreferences prefs) {
        this._tableName = tableName;
        this._columnName = columnName;
        this._columnType = columnType;
        this._columnSize = columnSize;
        this._decimalDigits = decimalDigits;
        this._nullable = nullable;
        this._prefs = prefs;
        String decimalDigitsString = 0 == this._decimalDigits ? "" : "," + this._decimalDigits;
        this._remarks = remarks;
        this._toString = this._columnName + this.getTableName() + this.getRemarksString() + this._columnType + "(" + this._columnSize + decimalDigitsString + ") " + (this._nullable ? "NULL" : "NOT NULL");
    }

    private String getTableName() {
        if (!this._prefs.isShowTableNameOfColumnsInCompletion() || StringUtilities.isEmpty((String)this._tableName, (boolean)true)) {
            return "";
        }
        return " (" + this._tableName + ")";
    }

    private String getTableQualifier() {
        if (StringUtilities.isEmpty((String)this._tableName, (boolean)true)) {
            return "";
        }
        return this._tableName + ".";
    }

    private String getRemarksString() {
        Object ret = " ";
        if (this._prefs.isShowRemarksInColumnCompletion() && null != this._remarks && 0 < this._remarks.trim().length()) {
            ret = " (" + this._remarks + ")  ";
        }
        return ret;
    }

    public String getCompletionString(CompletionParser completionParser) {
        Object ret = false == completionParser.isQualified() && this._prefs.isCompleteColumnsQualified() ? this.getTableQualifier() + this.getCompareString() : super.getCompletionString();
        return CompletionCaseSpelling.valueOf(this._prefs.getColumnCaseSpelling()).adjustCaseSpelling((String)ret);
    }

    public String getCompareString() {
        return this._columnName;
    }

    public String toString() {
        return this._toString;
    }
}

