/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.codecompletion;

import java.awt.Component;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JOptionPane;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.TableAliasInfo;
import net.sourceforge.squirrel_sql.fw.sql.IProcedureInfo;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.IUDTInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.codecompletion.CodeCompletionAutoCorrectInfo;
import net.sourceforge.squirrel_sql.plugins.codecompletion.CodeCompletionCatalogInfo;
import net.sourceforge.squirrel_sql.plugins.codecompletion.CodeCompletionFunctionInfo;
import net.sourceforge.squirrel_sql.plugins.codecompletion.CodeCompletionInfo;
import net.sourceforge.squirrel_sql.plugins.codecompletion.CodeCompletionKeywordInfo;
import net.sourceforge.squirrel_sql.plugins.codecompletion.CodeCompletionPlugin;
import net.sourceforge.squirrel_sql.plugins.codecompletion.CodeCompletionSchemaInfo;
import net.sourceforge.squirrel_sql.plugins.codecompletion.CodeCompletionStoredProcedureInfo;
import net.sourceforge.squirrel_sql.plugins.codecompletion.CodeCompletionTableAliasInfo;
import net.sourceforge.squirrel_sql.plugins.codecompletion.CodeCompletionTableInfo;
import net.sourceforge.squirrel_sql.plugins.codecompletion.CodeCompletionTypeInfo;
import net.sourceforge.squirrel_sql.plugins.codecompletion.CodeCompletionUDTInfo;
import net.sourceforge.squirrel_sql.plugins.codecompletion.CompletionMatchTypeUtil;
import net.sourceforge.squirrel_sql.plugins.codecompletion.SyntaxExternalService;
import net.sourceforge.squirrel_sql.plugins.codecompletion.prefs.CodeCompletionPreferences;

public class CodeCompletionInfoCollection {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CodeCompletionInfoCollection.class);
    private Hashtable<String, Vector<CodeCompletionInfo>> _completionInfosByCataLogAndSchema = new Hashtable();
    private Vector<CodeCompletionTableAliasInfo> _aliasCompletionInfos = new Vector();
    private Vector<CodeCompletionSchemaInfo> _schemas = new Vector();
    private Vector<CodeCompletionCatalogInfo> _catalogs = new Vector();
    private ISession _session;
    private CodeCompletionPlugin _plugin;
    private boolean _useCompletionPrefs;
    private static final int MAX_COMPLETION_INFOS = 300;
    private static final String TOO_MANY_COMPLETION_INFOS = s_stringMgr.getString("codecompletion.listTruncated");
    private CodeCompletionPreferences _prefs;

    public CodeCompletionInfoCollection(ISession session, CodeCompletionPlugin plugin, boolean useCompletionPrefs) {
        this._session = session;
        this._plugin = plugin;
        this._useCompletionPrefs = useCompletionPrefs;
        this._prefs = (CodeCompletionPreferences)this._session.getPluginObject((IPlugin)this._plugin, "codecompletionprefs");
        this._session.getSchemaInfo().addSchemaInfoUpdateListener(() -> {
            this._completionInfosByCataLogAndSchema = new Hashtable();
        });
    }

    private void load(String catalog, String schema, boolean showLoadingMessage) {
        String key = (catalog + "," + schema).toUpperCase();
        if (null == this._completionInfosByCataLogAndSchema.get(key)) {
            if (!this._session.getSchemaInfo().isLoaded()) {
                if (showLoadingMessage) {
                    String msg = s_stringMgr.getString("codecompletion.beingLoaded");
                    JOptionPane.showMessageDialog((Component)this._session.getApplication().getMainFrame(), msg);
                }
                return;
            }
            Vector<CodeCompletionInfo> completionInfos = new Vector<CodeCompletionInfo>();
            ITableInfo[] tables = this._session.getSchemaInfo().getITableInfos(catalog, schema);
            Hashtable<String, CodeCompletionTableInfo> completionInfoByUcTableName = new Hashtable<String, CodeCompletionTableInfo>();
            for (int i = 0; i < tables.length; ++i) {
                String ucTableName = tables[i].getSimpleName().toUpperCase();
                CodeCompletionTableInfo dupl = (CodeCompletionTableInfo)((Object)completionInfoByUcTableName.get(ucTableName));
                CodeCompletionTableInfo tableInfo = new CodeCompletionTableInfo(tables[i].getSimpleName(), tables[i].getType(), tables[i].getCatalogName(), tables[i].getSchemaName(), this._useCompletionPrefs, this._prefs, this._session);
                if (null != dupl) {
                    tableInfo.setHasDuplicateNameInDfifferentSchemas();
                    dupl.setHasDuplicateNameInDfifferentSchemas();
                }
                completionInfos.add(tableInfo);
                completionInfoByUcTableName.put(ucTableName, tableInfo);
            }
            IProcedureInfo[] storedProceduresInfos = this._session.getSchemaInfo().getStoredProceduresInfos(catalog, schema);
            for (int i = 0; i < storedProceduresInfos.length; ++i) {
                CodeCompletionStoredProcedureInfo buf = new CodeCompletionStoredProcedureInfo(storedProceduresInfos[i].getSimpleName(), storedProceduresInfos[i].getProcedureType(), this._session, catalog, schema, this._useCompletionPrefs, this._prefs);
                completionInfos.add(buf);
            }
            if (this._prefs.isIncludeUDTs()) {
                IUDTInfo[] udtInfos = this._session.getSchemaInfo().getUDTInfos(catalog, schema);
                for (int i = 0; i < udtInfos.length; ++i) {
                    CodeCompletionUDTInfo buf = new CodeCompletionUDTInfo(udtInfos[i].getSimpleName(), udtInfos[i].getDataType(), catalog, schema);
                    completionInfos.add(buf);
                }
            }
            if (null == catalog && null == schema) {
                String[] keywords = this._session.getSchemaInfo().getKeywords();
                for (int i = 0; i < keywords.length; ++i) {
                    completionInfos.add(new CodeCompletionKeywordInfo(keywords[i]));
                }
                String[] dataTypes = this._session.getSchemaInfo().getDataTypes();
                for (int i = 0; i < dataTypes.length; ++i) {
                    if (this._session.getSchemaInfo().isTable(dataTypes[i])) continue;
                    completionInfos.add(new CodeCompletionTypeInfo(dataTypes[i]));
                }
                String[] functions = this._session.getSchemaInfo().getFunctions();
                for (int i = 0; i < functions.length; ++i) {
                    completionInfos.add(new CodeCompletionFunctionInfo(functions[i]));
                }
                String[] catalogs = this._session.getSchemaInfo().getCatalogs();
                for (int i = 0; i < catalogs.length; ++i) {
                    completionInfos.add(new CodeCompletionCatalogInfo(catalogs[i], this._prefs));
                    this._catalogs.add(new CodeCompletionCatalogInfo(catalogs[i], this._prefs));
                }
                String[] schemas = this._session.getSchemaInfo().getSchemas();
                for (int i = 0; i < schemas.length; ++i) {
                    completionInfos.add(new CodeCompletionSchemaInfo(schemas[i], this._prefs));
                    this._schemas.add(new CodeCompletionSchemaInfo(schemas[i], this._prefs));
                }
                SyntaxExternalService syntaxExternalService = (SyntaxExternalService)this._session.getApplication().getPluginManager().bindExternalPluginService("syntax", SyntaxExternalService.class);
                if (null == syntaxExternalService) {
                    this._session.showMessage(s_stringMgr.getString("codecompletion.useSyntaxPlugin"));
                } else {
                    Hashtable<String, String> autoCorrections = syntaxExternalService.getAutoCorrects();
                    Enumeration<String> e = autoCorrections.keys();
                    while (e.hasMoreElements()) {
                        String toCorrect = e.nextElement();
                        String correction = autoCorrections.get(toCorrect);
                        completionInfos.add(new CodeCompletionAutoCorrectInfo(toCorrect, correction));
                    }
                }
            }
            Collections.sort(completionInfos);
            this._completionInfosByCataLogAndSchema.put(key, completionInfos);
        }
    }

    public CodeCompletionInfo[] getInfosStartingWith(String catalog, String schema, String prefix, int pos) {
        CodeCompletionInfo buf;
        int i;
        this.load(catalog, schema, true);
        Vector<CodeCompletionInfo> completionInfos = this.getCompletionInfos(catalog, schema);
        if (null == completionInfos) {
            return new CodeCompletionInfo[0];
        }
        String trimmedPrefix = prefix.trim();
        if ("".equals(trimmedPrefix)) {
            Vector<CodeCompletionInfo> buf2 = new Vector<CodeCompletionInfo>();
            buf2.addAll(this._aliasCompletionInfos);
            if (300 < completionInfos.size()) {
                buf2.addAll(completionInfos.subList(0, 300));
                this._session.showMessage(TOO_MANY_COMPLETION_INFOS);
            } else {
                buf2.addAll(completionInfos);
            }
            return buf2.toArray(new CodeCompletionInfo[0]);
        }
        Vector<CodeCompletionTableAliasInfo> ret = new Vector<CodeCompletionTableAliasInfo>();
        for (i = 0; i < this._aliasCompletionInfos.size(); ++i) {
            buf = this._aliasCompletionInfos.get(i);
            if (!buf.isInStatementOfAlias(pos) || !buf.matchesCompletionStringStart(trimmedPrefix, CompletionMatchTypeUtil.matchTypeOf(this._useCompletionPrefs, this._prefs))) continue;
            ret.add((CodeCompletionTableAliasInfo)buf);
        }
        for (i = 0; i < completionInfos.size(); ++i) {
            buf = completionInfos.get(i);
            if (!buf.matchesCompletionStringStart(trimmedPrefix, CompletionMatchTypeUtil.matchTypeOf(this._useCompletionPrefs, this._prefs))) continue;
            ret.add((CodeCompletionTableAliasInfo)buf);
            if (300 >= ret.size()) continue;
            this._session.showMessage(TOO_MANY_COMPLETION_INFOS);
            break;
        }
        return ret.toArray(new CodeCompletionInfo[0]);
    }

    private Vector<CodeCompletionInfo> getCompletionInfos(String catalog, String schema) {
        String key = (catalog + "," + schema).toUpperCase();
        Vector<CodeCompletionInfo> ret = this._completionInfosByCataLogAndSchema.get(key);
        if (null == ret) {
            this.load(catalog, schema, false);
        }
        ret = this._completionInfosByCataLogAndSchema.get(key);
        return ret;
    }

    public void replaceLastAliasInfos(TableAliasInfo[] aliasInfos) {
        this._aliasCompletionInfos = new Vector(aliasInfos.length);
        for (int i = 0; i < aliasInfos.length; ++i) {
            if (aliasInfos[i].getAliasName().startsWith("#")) continue;
            this._aliasCompletionInfos.add(new CodeCompletionTableAliasInfo(aliasInfos[i], this._useCompletionPrefs, this._prefs));
        }
    }

    public boolean isCatalog(String name) {
        for (int i = 0; i < this._catalogs.size(); ++i) {
            CodeCompletionCatalogInfo info = this._catalogs.get(i);
            if (!info.getCompareString().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isSchema(String name) {
        for (int i = 0; i < this._schemas.size(); ++i) {
            CodeCompletionSchemaInfo info = this._schemas.get(i);
            if (!info.getCompareString().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean addCompletionsAtListBegin(String catalog, String schema, CodeCompletionInfo[] completions) {
        Vector<CodeCompletionInfo> completionInfos = this.getCompletionInfos(catalog, schema);
        if (null == completionInfos) {
            return false;
        }
        Arrays.sort((Object[])completions);
        completionInfos.addAll(0, Arrays.asList(completions));
        return true;
    }
}

