/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.codecompletion;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.timeoutproxy.MetaDataTimeOutProxyFactory;
import net.sourceforge.squirrel_sql.plugins.codecompletion.CodeCompletionInfo;
import net.sourceforge.squirrel_sql.plugins.codecompletion.prefs.CodeCompletionPreferences;
import net.sourceforge.squirrel_sql.plugins.codecompletion.prefs.PrefixedConfig;

public class CodeCompletionStoredProcedureInfo
extends CodeCompletionInfo {
    private String _procName;
    private int _procType;
    private ISession _session;
    private boolean _useCompletionPrefs;
    private String _catalog;
    private String _schema;
    private int _moveCarretBackCount = 0;
    private String _toString;
    private String _params = null;
    private CodeCompletionPreferences _prefs;

    public CodeCompletionStoredProcedureInfo(String procName, int procType, ISession session, String catalog, String schema, boolean useCompletionPrefs, CodeCompletionPreferences prefs) {
        this._procName = procName;
        this._procType = procType;
        this._session = session;
        this._useCompletionPrefs = useCompletionPrefs;
        this._prefs = prefs;
        this._catalog = catalog;
        this._schema = schema;
        this._toString = this._procName + " (SP)";
    }

    public String getCompareString() {
        return this._procName;
    }

    public String getCompletionString() {
        try {
            if (!this._useCompletionPrefs) {
                this._moveCarretBackCount = 0;
                return this._procName;
            }
            Object ret = "";
            int completionConfig = this.getCopmpletionConfig();
            this._moveCarretBackCount = 0;
            String params = this.getParams();
            switch (completionConfig) {
                case 0: {
                    ret = "{call " + this._procName + "(" + params + ")}";
                    if (0 >= params.length()) break;
                    this._moveCarretBackCount = params.length() + 2;
                    break;
                }
                case 1: {
                    ret = "{call " + this._procName + "()}";
                    if (0 >= params.length()) break;
                    this._moveCarretBackCount = 2;
                    break;
                }
                case 2: {
                    ret = this._procName + "(" + params + ")";
                    if (0 >= params.length()) break;
                    this._moveCarretBackCount = params.length() + 1;
                    break;
                }
                case 3: {
                    if (0 < params.length()) {
                        this._moveCarretBackCount = 1;
                    }
                    ret = this._procName + "()";
                }
            }
            return ret;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private int getCopmpletionConfig() {
        PrefixedConfig[] prefixedConfigs = this._prefs.getPrefixedConfigs();
        for (int i = 0; i < prefixedConfigs.length; ++i) {
            if (!this._procName.toUpperCase().startsWith(prefixedConfigs[i].getPrefix().toUpperCase())) continue;
            return prefixedConfigs[i].getCompletionConfig();
        }
        return this._prefs.getGeneralCompletionConfig();
    }

    private String getParams() throws SQLException {
        if (null == this._params) {
            DatabaseMetaData databaseMetaData = MetaDataTimeOutProxyFactory.wrap(() -> this._session.getSQLConnection().getConnection().getMetaData(), (ISession)this._session);
            ResultSet res = databaseMetaData.getProcedureColumns(this._catalog, this._schema, this._procName, null);
            ArrayList<String> ret = new ArrayList<String>();
            while (res.next()) {
                switch (res.getInt("COLUMN_TYPE")) {
                    case 1: 
                    case 2: 
                    case 4: {
                        ret.add(this.getParamString(res));
                    }
                }
            }
            res.close();
            String[] _paramStrings = ret.toArray(new String[ret.size()]);
            this._params = "";
            if (0 < _paramStrings.length) {
                this._params = this._params + _paramStrings[0];
            }
            for (int i = 1; i < _paramStrings.length; ++i) {
                this._params = this._params + ", " + _paramStrings[i];
            }
        }
        return this._params;
    }

    private String getParamString(ResultSet res) throws SQLException {
        Object ret = "<";
        switch (res.getInt("COLUMN_TYPE")) {
            case 1: {
                ret = (String)ret + "IN ";
                break;
            }
            case 4: {
                ret = (String)ret + "OUT ";
                break;
            }
            case 2: {
                ret = (String)ret + "INOUT ";
            }
        }
        ret = (String)ret + res.getString("TYPE_NAME") + " ";
        ret = (String)ret + res.getString("COLUMN_NAME");
        String remarks = res.getString("REMARKS");
        if (null != remarks) {
            ret = (String)ret + " " + remarks.replace('\n', ' ');
        }
        ret = (String)ret + ">";
        return ret;
    }

    public String toString() {
        return this._toString;
    }

    @Override
    public int getMoveCarretBackCount() {
        return this._moveCarretBackCount;
    }

    public int getProcType() {
        return this._procType;
    }

    public void setProcType(int type) {
        this._procType = type;
    }
}

