/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.codecompletion;

import java.util.ArrayList;
import java.util.Arrays;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLTokenListener;
import net.sourceforge.squirrel_sql.client.session.parser.ParserEventsAdapter;
import net.sourceforge.squirrel_sql.client.session.parser.ParserEventsListener;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.TableAliasInfo;
import net.sourceforge.squirrel_sql.client.session.schemainfo.synonym.SynonymHandler;
import net.sourceforge.squirrel_sql.fw.completion.CompletionCandidates;
import net.sourceforge.squirrel_sql.fw.completion.CompletionInfo;
import net.sourceforge.squirrel_sql.fw.completion.util.CompletionParser;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.codecompletion.CodeCompletionInfo;
import net.sourceforge.squirrel_sql.plugins.codecompletion.CodeCompletionInfoCollection;
import net.sourceforge.squirrel_sql.plugins.codecompletion.CodeCompletionPlugin;
import net.sourceforge.squirrel_sql.plugins.codecompletion.CodeCompletionTableAliasInfo;
import net.sourceforge.squirrel_sql.plugins.codecompletion.CodeCompletionTableInfo;
import net.sourceforge.squirrel_sql.plugins.codecompletion.CodeCompletorModel;
import net.sourceforge.squirrel_sql.plugins.codecompletion.prefs.CodeCompletionPreferences;

public class StandardCompletorModel {
    private ISession _session;
    private ILogger _log = LoggerController.createLogger(CodeCompletorModel.class);
    private CodeCompletionInfoCollection _codeCompletionInfos;
    private ArrayList<String> _lastSelectedCompletionNames = new ArrayList();
    private CodeCompletionPlugin _plugin;
    private SynonymHandler _synonymHandler;

    StandardCompletorModel(ISession session, CodeCompletionPlugin plugin, CodeCompletionInfoCollection codeCompletionInfos, IIdentifier sqlEntryPanelIdentifier) {
        this._plugin = plugin;
        try {
            this._session = session;
            this._codeCompletionInfos = codeCompletionInfos;
            this._synonymHandler = new SynonymHandler(this._session.getMetaData());
            this._session.getParserEventsProcessor(sqlEntryPanelIdentifier).addParserEventsListener((ParserEventsListener)new ParserEventsAdapter(){

                public void aliasesFound(TableAliasInfo[] aliasInfos) {
                    StandardCompletorModel.this.onAliasesFound(aliasInfos);
                }
            });
        }
        catch (Exception e) {
            this._log.error((Object)"Could not get DB-Meta data", (Throwable)e);
        }
    }

    private void onAliasesFound(TableAliasInfo[] aliasInfos) {
        this._codeCompletionInfos.replaceLastAliasInfos(aliasInfos);
    }

    CompletionCandidates getCompletionCandidates(String textTillCarret) {
        CompletionParser parser = new CompletionParser(textTillCarret);
        ArrayList<CodeCompletionInfo> ret = new ArrayList<CodeCompletionInfo>();
        if (!parser.isQualified()) {
            ret.addAll(this.getColumnsFromLastSelectionStartingWith(parser.getStringToParse()));
            ret.addAll(Arrays.asList(this._codeCompletionInfos.getInfosStartingWith(null, null, parser.getStringToParse(), parser.getStringToParsePosition())));
        } else {
            String catalog = null;
            int catAndSchemCount = 0;
            if (this._codeCompletionInfos.isCatalog(parser.getToken(0))) {
                catalog = parser.getToken(0);
                catAndSchemCount = 1;
            }
            String schema = null;
            if (this._codeCompletionInfos.isSchema(parser.getToken(0))) {
                schema = parser.getToken(0);
                catAndSchemCount = 1;
            } else if (this._codeCompletionInfos.isSchema(parser.getToken(1))) {
                schema = parser.getToken(1);
                catAndSchemCount = 2;
            }
            String tableNamePat1 = parser.getToken(parser.size() - 2);
            String colNamePat1 = parser.getToken(parser.size() - 1);
            if (0 < catAndSchemCount) {
                String tableNamePat2 = parser.getToken(catAndSchemCount);
                if (parser.size() > catAndSchemCount + 1) {
                    String colNamePat2 = parser.getToken(catAndSchemCount + 1);
                    ret.addAll(this.getColumnsForName(catalog, schema, tableNamePat2, colNamePat2, parser.getStringToParsePosition()));
                } else {
                    ret.addAll(Arrays.asList(this._codeCompletionInfos.getInfosStartingWith(catalog, schema, tableNamePat2, parser.getStringToParsePosition())));
                }
            } else {
                ret.addAll(this.getColumnsForName(null, null, tableNamePat1, colNamePat1, parser.getStringToParsePosition()));
            }
        }
        CompletionInfo[] ccis = ret.toArray(new CodeCompletionInfo[ret.size()]);
        return new CompletionCandidates(ccis, parser.getReplacementStart(), parser.getStringToReplace());
    }

    private ArrayList<? extends CodeCompletionInfo> getColumnsForName(String catalog, String schema, String name, String colNamePat, int colPos) {
        CodeCompletionInfo[] infos = this._codeCompletionInfos.getInfosStartingWith(catalog, schema, name, colPos);
        CodeCompletionInfo toReturn = null;
        if (colPos != -1) {
            for (int j = 0; j < infos.length; ++j) {
                CodeCompletionTableAliasInfo a;
                CodeCompletionInfo info = infos[j];
                if (!(info instanceof CodeCompletionTableAliasInfo) || !info.matchesCompletionString(name) || !(a = (CodeCompletionTableAliasInfo)info).isInStatementOfAlias(colPos)) continue;
                toReturn = a;
            }
        }
        if (toReturn == null) {
            for (int i = 0; i < infos.length; ++i) {
                if (!infos[i].matchesCompletionString(name) || this.ignoreAsCodeCompletionTableInfo(infos[i])) continue;
                toReturn = infos[i];
                break;
            }
        }
        if (toReturn == null) {
            return new ArrayList();
        }
        return toReturn.getColumns(this._session.getSchemaInfo(), colNamePat);
    }

    public boolean ignoreAsCodeCompletionTableInfo(CodeCompletionInfo info) {
        if (!(info instanceof CodeCompletionTableInfo)) {
            return false;
        }
        CodeCompletionTableInfo codeCompletionTableInfo = (CodeCompletionTableInfo)info;
        return this._synonymHandler.ignoreAsCodeCompletionTableInfo(codeCompletionTableInfo.getTableType());
    }

    private ArrayList<CodeCompletionInfo> getColumnsFromLastSelectionStartingWith(String colNamePat) {
        ArrayList<CodeCompletionInfo> ret = new ArrayList<CodeCompletionInfo>();
        for (String lastSelectedCompletionName : this._lastSelectedCompletionNames) {
            ret.addAll(this.getColumnsForName(null, null, lastSelectedCompletionName, colNamePat, -1));
        }
        return ret;
    }

    public SQLTokenListener getSQLTokenListener() {
        return new SQLTokenListener(){

            public void tableOrViewFound(String name) {
                StandardCompletorModel.this.performTableOrViewFound(name);
            }
        };
    }

    private void performTableOrViewFound(String name) {
        this._lastSelectedCompletionNames.remove(name);
        this._lastSelectedCompletionNames.add(0, name);
        CodeCompletionPreferences prefs = (CodeCompletionPreferences)this._session.getPluginObject((IPlugin)this._plugin, "codecompletionprefs");
        int maxLastSelectedCompletionNames = prefs.getMaxLastSelectedCompletionNames();
        if (maxLastSelectedCompletionNames < this._lastSelectedCompletionNames.size()) {
            this._lastSelectedCompletionNames.remove(this._lastSelectedCompletionNames.size() - 1);
        }
    }

    public CodeCompletionInfoCollection getCodeCompletionInfoCollection() {
        return this._codeCompletionInfos;
    }
}

