/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.codecompletion.completionfunctions;

import java.lang.invoke.CallSite;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.schemainfo.ObjFilterMatcher;
import net.sourceforge.squirrel_sql.fw.sql.ForeignKeyInfo;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.databasemetadata.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.codecompletion.CodeCompletionInfo;
import net.sourceforge.squirrel_sql.plugins.codecompletion.completionfunctions.CodeCompletionFunction;
import net.sourceforge.squirrel_sql.plugins.codecompletion.completionfunctions.GenericCodeCompletionInfo;

public abstract class AbstractJoin
extends CodeCompletionFunction {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AbstractJoin.class);
    private ISession _session;

    public AbstractJoin(ISession session) {
        this._session = session;
    }

    @Override
    public CodeCompletionInfo[] getFunctionResults(String functionSting) {
        try {
            if (!this.functionMatches(functionSting)) {
                return null;
            }
            StringTokenizer st = new StringTokenizer(functionSting, ",");
            if (3 > st.countTokens()) {
                this._session.showMessage(s_stringMgr.getString("codecompletion.function.needsTwoArgs"));
                return null;
            }
            if (!functionSting.trim().endsWith(",")) {
                this._session.showMessage(s_stringMgr.getString("codecompletion.function.mustEndWith"));
                return null;
            }
            st.nextToken();
            String catalog = this._session.getSQLConnection().getCatalog();
            SQLDatabaseMetaData jdbcMetaData = this._session.getSQLConnection().getSQLMetaData();
            Vector<String> tables = new Vector<String>();
            HashMap<String, String> schemas = new HashMap<String, String>();
            while (st.hasMoreTokens()) {
                ITableInfo[] infos;
                String[] catSchemTab = st.nextToken().trim().split("\\.");
                String schema = null;
                String table = catSchemTab[catSchemTab.length - 1];
                if (2 <= catSchemTab.length) {
                    schema = catSchemTab[catSchemTab.length - 2];
                    schemas.put(schema, schema);
                }
                if (null == (table = this._session.getSchemaInfo().getCaseSensitiveTableName(table))) {
                    this._session.showMessage(s_stringMgr.getString("codecompletion.unknowntable", new Object[]{table}));
                    return null;
                }
                tables.add(table);
                if (null != schema) continue;
                if (null == catalog) {
                    catalog = this._session.getSQLConnection().getCatalog();
                }
                if (0 == (infos = this._session.getSchemaInfo().getITableInfos(catalog, null, new ObjFilterMatcher(tables.get(0)), new String[]{"TABLE"})).length) {
                    infos = this._session.getSchemaInfo().getITableInfos(null, null, new ObjFilterMatcher(tables.get(0)), new String[]{"TABLE"});
                }
                for (int i = 0; i < infos.length; ++i) {
                    String schemBuf = infos[i].getSchemaName();
                    schemas.put(schemBuf, schemBuf);
                }
            }
            Vector<CodeCompletionInfo> ret = new Vector<CodeCompletionInfo>();
            Iterator i = schemas.keySet().iterator();
            while (i.hasNext()) {
                CodeCompletionInfo[] buf = this.getResultsForSchema(tables, jdbcMetaData, catalog, (String)i.next());
                ret.addAll(Arrays.asList(buf));
            }
            return ret.toArray(new CodeCompletionInfo[ret.size()]);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private CodeCompletionInfo[] getResultsForSchema(Vector<String> tables, SQLDatabaseMetaData jdbcMetaData, String catalog, String schema) throws SQLException {
        Vector<String> completions = new Vector<String>();
        completions.add("");
        for (int i = 1; i < tables.size(); ++i) {
            Hashtable<String, Vector<String>> conditionByFkName = new Hashtable<String, Vector<String>>();
            Hashtable<String, Vector<ColBuffer>> colBuffersByFkName = new Hashtable<String, Vector<ColBuffer>>();
            ForeignKeyInfo[] infos = jdbcMetaData.getImportedKeysInfo(catalog, schema, tables.get(i - 1));
            this.fillConditionByFkName(infos, tables.get(i - 1), tables.get(i), conditionByFkName, colBuffersByFkName);
            infos = jdbcMetaData.getExportedKeysInfo(catalog, schema, tables.get(i - 1));
            this.fillConditionByFkName(infos, tables.get(i - 1), tables.get(i), conditionByFkName, colBuffersByFkName);
            Vector<Object> twoTableCompletions = new Vector<Object>();
            Enumeration<String> e = conditionByFkName.keys();
            while (e.hasMoreElements()) {
                String fkName = e.nextElement();
                String joinClause = this.getJoinClause(fkName, tables.get(i - 1), tables.get(i), colBuffersByFkName);
                StringBuffer sb = new StringBuffer();
                sb.append(joinClause).append(tables.get(i)).append(" ON ");
                Vector<String> conditions = conditionByFkName.get(fkName);
                if (1 == conditions.size()) {
                    sb.append(conditions.get(0));
                } else if (1 < conditions.size()) {
                    sb.append("(");
                    sb.append(conditions.get(0));
                    for (int j = 1; j < conditions.size(); ++j) {
                        sb.append(" AND ").append(conditions.get(j));
                    }
                    sb.append(")");
                }
                sb.append("\n");
                twoTableCompletions.add(sb.toString());
            }
            if (0 == conditionByFkName.size()) {
                String joinClause = this.getJoinClause(null, tables.get(i - 1), tables.get(i), colBuffersByFkName);
                twoTableCompletions.add(joinClause + tables.get(i) + " ON " + tables.get(i - 1) + ". = " + tables.get(i) + ".\n");
            }
            Vector<CallSite> newCompletions = new Vector<CallSite>();
            for (int j = 0; j < completions.size(); ++j) {
                String begin = (String)completions.get(j);
                for (int k = 0; k < twoTableCompletions.size(); ++k) {
                    String end = (String)twoTableCompletions.get(k);
                    newCompletions.add((CallSite)((Object)(begin + end)));
                }
            }
            completions = newCompletions;
        }
        CodeCompletionInfo[] ret = new GenericCodeCompletionInfo[completions.size()];
        for (int i = 0; i < completions.size(); ++i) {
            ret[i] = new GenericCodeCompletionInfo((String)completions.get(i));
        }
        return ret;
    }

    protected abstract String getJoinClause(String var1, String var2, String var3, Hashtable<String, Vector<ColBuffer>> var4);

    private void fillConditionByFkName(ForeignKeyInfo[] infos, String table1, String table2, Hashtable<String, Vector<String>> conditionByFkName, Hashtable<String, Vector<ColBuffer>> colBuffersByFkName) throws SQLException {
        for (int i = 0; i < infos.length; ++i) {
            String pkTableName = infos[i].getPrimaryKeyTableName();
            String pkColumnName = infos[i].getPrimaryKeyColumnName();
            String fkTableName = infos[i].getForeignKeyTableName();
            String fkColumnName = infos[i].getForeignKeyColumnName();
            String fkName = infos[i].getForeignKeyName();
            if ((!pkTableName.equalsIgnoreCase(table2) || !fkTableName.equalsIgnoreCase(table1)) && (!fkTableName.equalsIgnoreCase(table2) || !pkTableName.equalsIgnoreCase(table1))) continue;
            Vector<String> conditions = conditionByFkName.get(fkName);
            if (null == conditions) {
                conditions = new Vector();
                conditionByFkName.put(fkName, conditions);
            }
            StringBuilder tmp = new StringBuilder(pkTableName);
            tmp.append(".");
            tmp.append(pkColumnName);
            tmp.append(" = ");
            tmp.append(fkTableName);
            tmp.append(".");
            tmp.append(fkColumnName);
            conditions.add(tmp.toString());
            Vector<ColBuffer> cols = colBuffersByFkName.get(fkName);
            if (null == cols) {
                cols = new Vector();
                colBuffersByFkName.put(fkName, cols);
            }
            cols.add(new ColBuffer(fkTableName, fkColumnName));
        }
    }

    static class ColBuffer {
        String tableName;
        String colName;

        public ColBuffer(String tableName, String colName) {
            this.tableName = tableName;
            this.colName = colName;
        }
    }
}

