/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.codecompletion.prefs;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.preferences.INewSessionPropertiesPanel;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.properties.ISessionPropertiesPanel;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.codecompletion.CompletionCaseSpelling;
import net.sourceforge.squirrel_sql.plugins.codecompletion.prefs.CodeCompletionPreferences;
import net.sourceforge.squirrel_sql.plugins.codecompletion.prefs.CodeCompletionPreferencesPanel;
import net.sourceforge.squirrel_sql.plugins.codecompletion.prefs.ConfigCboItem;
import net.sourceforge.squirrel_sql.plugins.codecompletion.prefs.PrefixesTableModel;

public class CodeCompletionPreferencesController
implements INewSessionPropertiesPanel,
ISessionPropertiesPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CodeCompletionPreferencesController.class);
    private CodeCompletionPreferences _prefs;
    private CodeCompletionPreferencesPanel _panel = new CodeCompletionPreferencesPanel();
    private JScrollPane _scrollPane = new JScrollPane(this._panel);

    public CodeCompletionPreferencesController(CodeCompletionPreferences prefs) {
        GUIUtils.forceScrollToBegin((JScrollPane)this._scrollPane);
        this._prefs = prefs;
        switch (this._prefs.getGeneralCompletionConfig()) {
            case 0: {
                this._panel.optSPWithParams.setSelected(true);
                break;
            }
            case 1: {
                this._panel.optSPWithoutParams.setSelected(true);
                break;
            }
            case 2: {
                this._panel.optUDFWithParams.setSelected(true);
                break;
            }
            case 3: {
                this._panel.optUDFWithoutParams.setSelected(true);
            }
        }
        PrefixesTableModel tm = new PrefixesTableModel(this._prefs.getPrefixedConfigs());
        this._panel.tblPrefixes.setModel(tm);
        TableColumn tcPrefix = new TableColumn();
        tcPrefix.setHeaderValue(s_stringMgr.getString("codecompletion.prefs.table.col.prefix"));
        tcPrefix.setModelIndex(0);
        this._panel.tblPrefixes.addColumn(tcPrefix);
        TableColumn tcCompletionConfig = new TableColumn();
        tcCompletionConfig.setHeaderValue(s_stringMgr.getString("codecompletion.prefs.table.col.config"));
        JComboBox<ConfigCboItem> cboConfigs = new JComboBox<ConfigCboItem>(ConfigCboItem.items);
        cboConfigs.setSelectedIndex(0);
        tcCompletionConfig.setCellEditor(new DefaultCellEditor(cboConfigs));
        tcCompletionConfig.setModelIndex(1);
        this._panel.tblPrefixes.addColumn(tcCompletionConfig);
        this._panel.txtMaxLastSelectedCompletionNames.setText("" + this._prefs.getMaxLastSelectedCompletionNames());
        this._panel.chkShowTableNameOfColumnsInCompletion.setSelected(this._prefs.isShowTableNameOfColumnsInCompletion());
        this._panel.chkCompleteColumnsQualified.setSelected(this._prefs.isCompleteColumnsQualified());
        this._panel.chkShowTableNameOfColumnsInCompletion.addActionListener(e -> this.onShowTableNameOfColumnsInCompletion());
        this.onShowTableNameOfColumnsInCompletion();
        this._panel.chkShowRemarksInColumnCompletion.setSelected(this._prefs.isShowRemarksInColumnCompletion());
        this._panel.chkMatchCamelCase.setSelected(this._prefs.isMatchCamelCase());
        this._panel.chkMatchCamelCase.addActionListener(e -> this.updateUI(this._panel.chkMatchCamelCase));
        this._panel.chkMatchContains.setSelected(this._prefs.isMatchContains());
        this._panel.chkMatchContains.addActionListener(e -> this.updateUI(this._panel.chkMatchContains));
        this._panel.chkIncludeUDTs.setSelected(this._prefs.isIncludeUDTs());
        this._panel.chkSortColumnsAlphabetically.setSelected(this._prefs.isSortColumnsAlphabetically());
        this._panel._cboColumnUpperLower.setSelectedItem((Object)CompletionCaseSpelling.valueOf(this._prefs.getColumnCaseSpelling()));
        this._panel._cboTableViewUpperLower.setSelectedItem((Object)CompletionCaseSpelling.valueOf(this._prefs.getTableViewCaseSpelling()));
        this._panel._cboSchemaUpperLower.setSelectedItem((Object)CompletionCaseSpelling.valueOf(this._prefs.getSchemaCaseSpelling()));
        this._panel._cboCatalogUpperLower.setSelectedItem((Object)CompletionCaseSpelling.valueOf(this._prefs.getCatalogCaseSpelling()));
        this._panel.btnNewRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeCompletionPreferencesController.this.onAddRow();
            }
        });
        this._panel.btnDeleteRows.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeCompletionPreferencesController.this.onDeleteRows();
            }
        });
    }

    private void onShowTableNameOfColumnsInCompletion() {
        if (this._panel.chkShowTableNameOfColumnsInCompletion.isSelected()) {
            this._panel.chkCompleteColumnsQualified.setEnabled(true);
        } else {
            this._panel.chkCompleteColumnsQualified.setSelected(false);
            this._panel.chkCompleteColumnsQualified.setEnabled(false);
        }
    }

    private void onDeleteRows() {
        this.stopEditing();
        PrefixesTableModel tm = (PrefixesTableModel)this._panel.tblPrefixes.getModel();
        int[] selRows = this._panel.tblPrefixes.getSelectedRows();
        tm.removeRows(selRows);
    }

    private void updateUI(JCheckBox chkChanged) {
        if (chkChanged == this._panel.chkMatchContains && this._panel.chkMatchContains.isSelected()) {
            this._panel.chkMatchCamelCase.setSelected(false);
        }
        if (chkChanged == this._panel.chkMatchCamelCase && this._panel.chkMatchCamelCase.isSelected()) {
            this._panel.chkMatchContains.setSelected(false);
        }
    }

    private void onAddRow() {
        PrefixesTableModel tm = (PrefixesTableModel)this._panel.tblPrefixes.getModel();
        tm.addNewConfig();
    }

    public void initialize(IApplication app) {
    }

    public void initialize(IApplication app, ISession session) {
    }

    public Component getPanelComponent() {
        return this._scrollPane;
    }

    public void applyChanges() {
        if (this._panel.optSPWithParams.isSelected()) {
            this._prefs.setGeneralCompletionConfig(0);
        } else if (this._panel.optSPWithoutParams.isSelected()) {
            this._prefs.setGeneralCompletionConfig(1);
        } else if (this._panel.optUDFWithParams.isSelected()) {
            this._prefs.setGeneralCompletionConfig(2);
        } else if (this._panel.optUDFWithoutParams.isSelected()) {
            this._prefs.setGeneralCompletionConfig(3);
        } else {
            throw new IllegalStateException("No valid config selected");
        }
        this.stopEditing();
        PrefixesTableModel tm = (PrefixesTableModel)this._panel.tblPrefixes.getModel();
        this._prefs.setPrefixedConfigs(tm.getData());
        try {
            this._prefs.setMaxLastSelectedCompletionNames(Math.max(0, Integer.parseInt(this._panel.txtMaxLastSelectedCompletionNames.getText())));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this._prefs.setShowTableNameOfColumnsInCompletion(this._panel.chkShowTableNameOfColumnsInCompletion.isSelected());
        this._prefs.setCompleteColumnsQualified(this._panel.chkCompleteColumnsQualified.isSelected());
        this._prefs.setShowRemarksInColumnCompletion(this._panel.chkShowRemarksInColumnCompletion.isSelected());
        this._prefs.setMatchCamelCase(this._panel.chkMatchCamelCase.isSelected());
        this._prefs.setMatchContains(this._panel.chkMatchContains.isSelected());
        this._prefs.setIncludeUDTs(this._panel.chkIncludeUDTs.isSelected());
        this._prefs.setSortColumnsAlphabetically(this._panel.chkSortColumnsAlphabetically.isSelected());
        this._prefs.setColumnCaseSpelling(((CompletionCaseSpelling)((Object)this._panel._cboColumnUpperLower.getSelectedItem())).name());
        this._prefs.setTableViewCaseSpelling(((CompletionCaseSpelling)((Object)this._panel._cboTableViewUpperLower.getSelectedItem())).name());
        this._prefs.setSchemaCaseSpelling(((CompletionCaseSpelling)((Object)this._panel._cboSchemaUpperLower.getSelectedItem())).name());
        this._prefs.setCatalogCaseSpelling(((CompletionCaseSpelling)((Object)this._panel._cboCatalogUpperLower.getSelectedItem())).name());
    }

    private void stopEditing() {
        TableCellEditor cellEditor = this._panel.tblPrefixes.getCellEditor();
        if (null != cellEditor) {
            cellEditor.stopCellEditing();
        }
    }

    public String getTitle() {
        return s_stringMgr.getString("codeCompletion.PrefsTabTitle");
    }

    public String getHint() {
        return s_stringMgr.getString("codeCompletion.PrefsTabTitleHint");
    }
}

