/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.sourceforge.squirrel_sql.client.IApplicationArgument;
import net.sourceforge.squirrel_sql.client.IApplicationArguments;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class ApplicationArguments
implements IApplicationArguments {
    private static volatile ApplicationArguments s_instance;
    private final Options _options = new Options();
    private CommandLine _cmdLine;
    private String[] _rawArgs;
    private String _squirrelHome = null;
    private String _userSettingsDir = null;
    private String _loggingConfigFile = null;
    private String _logLevel = null;
    private List<String> _pluginList = null;
    private Integer _shutdownTimerSeconds = null;
    private String _startupJdbcUrl;
    private String _startupAliasName;
    private boolean _detectLongRunningSwingEDTEvents;

    private ApplicationArguments(String[] args) {
        this.createOptions();
        this._rawArgs = args;
    }

    @Override
    public void validateArgs(final boolean stopAtUnknownArgs) throws IllegalArgumentException {
        GnuParser parser = new GnuParser(){

            protected void processOption(String arg, ListIterator iter) throws ParseException {
                if (stopAtUnknownArgs || this.getOptions().hasOption(arg)) {
                    super.processOption(arg, iter);
                }
            }
        };
        try {
            this._cmdLine = parser.parse(this._options, this._rawArgs);
        }
        catch (ParseException ex) {
            System.err.println("Parsing failed. Reason: " + ex.getMessage());
            this.printHelp();
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    public void addPluginApplicationArguments(Collection<IApplicationArgument> args) throws IllegalArgumentException {
        if (args.isEmpty()) {
            return;
        }
        HashMap options = new HashMap(args.size());
        for (IApplicationArgument iApplicationArgument : args) {
            Option option = new Option(iApplicationArgument.getArgumentName(), iApplicationArgument.getDescription());
            option.setOptionalArg(false);
            option.setRequired(iApplicationArgument.isRequired());
            option.setType(String.class);
            option.setArgs(iApplicationArgument.getNumberOfArgumentValues());
            this._options.addOption(option);
        }
        this.validateArgs(false);
        for (Map.Entry entry : options.entrySet()) {
            if (!this._options.hasOption(((Option)entry.getValue()).getArgName())) continue;
            ((IApplicationArgument)entry.getKey()).setArgumentValues(Arrays.asList(((Option)entry.getValue()).getValues()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized boolean initialize(String[] args) {
        if (s_instance == null) {
            try {
                String pluginList;
                s_instance = new ApplicationArguments(args);
                s_instance.validateArgs(false);
                if (ApplicationArguments.s_instance._cmdLine.hasOption(IOptions.SQUIRREL_HOME[0])) {
                    ApplicationArguments.s_instance._squirrelHome = ApplicationArguments.s_instance._cmdLine.getOptionValue(IOptions.SQUIRREL_HOME[0]);
                }
                if (ApplicationArguments.s_instance._cmdLine.hasOption(IOptions.USER_SETTINGS_DIR[0])) {
                    ApplicationArguments.s_instance._userSettingsDir = ApplicationArguments.s_instance._cmdLine.getOptionValue(IOptions.USER_SETTINGS_DIR[0]);
                }
                if (ApplicationArguments.s_instance._cmdLine.hasOption(IOptions.LOG_FILE[0])) {
                    ApplicationArguments.s_instance._loggingConfigFile = ApplicationArguments.s_instance._cmdLine.getOptionValue(IOptions.LOG_FILE[0]);
                }
                if (ApplicationArguments.s_instance._cmdLine.hasOption(IOptions.LOG_LEVEL[0])) {
                    ApplicationArguments.s_instance._logLevel = ApplicationArguments.s_instance._cmdLine.getOptionValue(IOptions.LOG_LEVEL[0]);
                }
                if (ApplicationArguments.s_instance._cmdLine.hasOption(IOptions.PLUGIN_LIST[0]) && (pluginList = ApplicationArguments.s_instance._cmdLine.getOptionValue(IOptions.PLUGIN_LIST[0])) != null && !pluginList.isEmpty()) {
                    String[] pluginArr = pluginList.split(",");
                    ApplicationArguments.s_instance._pluginList = new ArrayList<String>(Arrays.asList(pluginArr));
                    ApplicationArguments.s_instance._pluginList = Collections.unmodifiableList(ApplicationArguments.s_instance._pluginList);
                }
                if (ApplicationArguments.s_instance._cmdLine.hasOption(IOptions.SHUTDOWN_TIMEOUT_SECONDS[0])) {
                    ApplicationArguments.s_instance._shutdownTimerSeconds = Integer.parseInt(ApplicationArguments.s_instance._cmdLine.getOptionValue(IOptions.SHUTDOWN_TIMEOUT_SECONDS[0]));
                }
                if (ApplicationArguments.s_instance._cmdLine.hasOption(IOptions.CONNECT_JDBC_URL[0])) {
                    ApplicationArguments.s_instance._startupJdbcUrl = ApplicationArguments.s_instance._cmdLine.getOptionValue(IOptions.CONNECT_JDBC_URL[0]);
                }
                if (!ApplicationArguments.s_instance._cmdLine.hasOption(IOptions.CONNECT_ALIAS[0])) return true;
                ApplicationArguments.s_instance._startupAliasName = ApplicationArguments.s_instance._cmdLine.getOptionValue(IOptions.CONNECT_ALIAS[0]);
                return true;
            }
            catch (IllegalArgumentException ex) {
                return false;
            }
        } else {
            System.out.println("ApplicationArguments.initialize() called twice");
        }
        return true;
    }

    public static ApplicationArguments getInstance() {
        if (s_instance == null) {
            s_instance = new ApplicationArguments(new String[0]);
        }
        return s_instance;
    }

    @Override
    public String getSquirrelHomeDirectory() {
        return this._squirrelHome;
    }

    @Override
    public String getUserSettingsDirectoryOverride() {
        return this._userSettingsDir;
    }

    public String getStartupJdbcUrl() {
        return this._startupJdbcUrl;
    }

    public String getStartupAliasName() {
        return this._startupAliasName;
    }

    @Override
    public boolean getShowSplashScreen() {
        return !this._cmdLine.hasOption(IOptions.NO_SPLASH[0]);
    }

    @Override
    public boolean getShowHelp() {
        return this._cmdLine.hasOption(IOptions.HELP[0]);
    }

    public boolean detectLongRunningSwingEDTEvents() {
        return this._cmdLine.hasOption(IOptions.DETECT_LONG_RUNNING_SWING_EDT_EVENTS[0]);
    }

    @Override
    public String getLoggingConfigFileName() {
        return this._loggingConfigFile;
    }

    public String getLogLevel() {
        return this._logLevel;
    }

    @Override
    public boolean getLoadPlugins() {
        return !this._cmdLine.hasOption(IOptions.NO_PLUGINS[0]);
    }

    @Override
    public boolean useDefaultMetalTheme() {
        return this._cmdLine.hasOption(IOptions.USE_DEFAULT_METAL_THEME[0]);
    }

    @Override
    public boolean useNativeLAF() {
        return this._cmdLine.hasOption(IOptions.USE_NATIVE_LAF[0]);
    }

    @Override
    public String[] getRawArguments() {
        return this._rawArgs;
    }

    @Override
    public boolean getUserInterfaceDebugEnabled() {
        return this._cmdLine.hasOption(IOptions.UI_DEBUG[0]);
    }

    @Override
    public List<String> getPluginList() {
        return this._pluginList;
    }

    public Integer getShutdownTimerSeconds() {
        return this._shutdownTimerSeconds;
    }

    void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("squirrel-sql", this._options);
    }

    private void createOptions() {
        Option opt = this.createAnOption(IOptions.NO_SPLASH);
        this._options.addOption(opt);
        opt = this.createAnOption(IOptions.HELP);
        this._options.addOption(opt);
        opt = this.createAnOption(IOptions.NO_PLUGINS);
        this._options.addOption(opt);
        opt = this.createAnOption(IOptions.USE_DEFAULT_METAL_THEME);
        this._options.addOption(opt);
        opt = this.createAnOption(IOptions.USE_NATIVE_LAF);
        this._options.addOption(opt);
        opt = this.createAnOptionWithArgument(IOptions.SQUIRREL_HOME);
        this._options.addOption(opt);
        opt = this.createAnOptionWithArgument(IOptions.USER_SETTINGS_DIR);
        this._options.addOption(opt);
        opt = this.createAnOptionWithArgument(IOptions.LOG_FILE);
        this._options.addOption(opt);
        opt = this.createAnOptionWithArgument(IOptions.LOG_LEVEL);
        this._options.addOption(opt);
        opt = this.createAnOption(IOptions.UI_DEBUG);
        this._options.addOption(opt);
        opt = this.createAnOptionWithArgument(IOptions.PLUGIN_LIST);
        this._options.addOption(opt);
        opt = this.createAnOptionWithArgument(IOptions.SHUTDOWN_TIMEOUT_SECONDS);
        this._options.addOption(opt);
        opt = this.createAnOption(IOptions.DETECT_LONG_RUNNING_SWING_EDT_EVENTS);
        this._options.addOption(opt);
        opt = this.createAnOptionWithArgument(IOptions.CONNECT_JDBC_URL);
        this._options.addOption(opt);
        opt = this.createAnOptionWithArgument(IOptions.CONNECT_ALIAS);
        this._options.addOption(opt);
    }

    private Option createAnOption(String[] argInfo) {
        Option opt = new Option(argInfo[0], argInfo[2]);
        if (!ApplicationArguments.isStringEmpty(argInfo[1])) {
            opt.setLongOpt(argInfo[1]);
        }
        return opt;
    }

    private Option createAnOptionWithArgument(String[] argInfo) {
        OptionBuilder.withArgName((String)argInfo[0]);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)argInfo[2]);
        Option opt = OptionBuilder.create((String)argInfo[0]);
        if (!ApplicationArguments.isStringEmpty(argInfo[1])) {
            opt.setLongOpt(argInfo[1]);
        }
        return opt;
    }

    private static boolean isStringEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static interface IOptions {
        public static final String[] HELP = new String[]{"h", "help", "Display Help and exit"};
        public static final String[] SQUIRREL_HOME = new String[]{"home", "squirrel-home", "SQuirreL home directory"};
        public static final String[] USE_DEFAULT_METAL_THEME = new String[]{"m", "use-default-metal-theme", "Use default metal theme (not valid if L&F Plugin is used)"};
        public static final String[] USE_NATIVE_LAF = new String[]{"n", "native-laf", "Use native look and feel"};
        public static final String[] NO_PLUGINS = new String[]{"nop", "no-plugins", "Don't load plugins"};
        public static final String[] NO_SPLASH = new String[]{"nos", "no-splash", "Don't display splash screen"};
        public static final String[] USER_SETTINGS_DIR = new String[]{"userdir", "user-settings-dir", "User settings directory"};
        public static final String[] LOG_FILE = new String[]{"l", "log-config-file", "deprecated/unused"};
        public static final String[] LOG_LEVEL = new String[]{"level", "log-level", "Minimum log level to write to <userdir>" + File.separator + "logs" + File.separator + ". Values: ERROR, WARNING, INFO (default), DEBUG"};
        public static final String[] UI_DEBUG = new String[]{"uidebug", "user-interface-debugging", "Provides tool-tips and highlighting of UI components for easy identification"};
        public static final String[] PLUGIN_LIST = new String[]{"pluginlist", "plugin-classpath-list", "Specify a comma-delimited list of plugins to load from the CLASSPATH"};
        public static final String[] SHUTDOWN_TIMEOUT_SECONDS = new String[]{"s", "shutdown-timeout-seconds", "Specify the number of seconds to allow the application to run before exiting the VM"};
        public static final String[] DETECT_LONG_RUNNING_SWING_EDT_EVENTS = new String[]{"detectEDT", "detect-long-running-swing-edt-events", "Detect long running Swing Event Dispatch Thread events"};
        public static final String[] CONNECT_JDBC_URL = new String[]{"cu", "connect-url", "Connect to JDBC-URL (requires exiting Alias for JDBC-URL)"};
        public static final String[] CONNECT_ALIAS = new String[]{"ca", "connect-alias", "Connect to Alias (Alias name)"};
        public static final String[][] ALL_OPTIONS = new String[][]{HELP, SQUIRREL_HOME, USE_DEFAULT_METAL_THEME, USE_NATIVE_LAF, NO_SPLASH, USER_SETTINGS_DIR, LOG_FILE, LOG_LEVEL, UI_DEBUG, PLUGIN_LIST, SHUTDOWN_TIMEOUT_SECONDS, DETECT_LONG_RUNNING_SWING_EDT_EVENTS, CONNECT_JDBC_URL, CONNECT_ALIAS};
    }
}

