/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.util.ApplicationFiles;

public class FileTransformer {
    public static String transform(ApplicationFiles appFiles) {
        return FileTransformer.convertAliases_2_2_to_2_3(appFiles);
    }

    private static String convertAliases_2_2_to_2_3(ApplicationFiles appFiles) {
        if (appFiles.getDatabaseAliasesFile().exists()) {
            return null;
        }
        if (!appFiles.getDatabaseAliasesFile_before_version_2_3().exists()) {
            return null;
        }
        try {
            FileReader fr = new FileReader(appFiles.getDatabaseAliasesFile_before_version_2_3());
            BufferedReader br = new BufferedReader(fr);
            FileWriter fw = new FileWriter(appFiles.getDatabaseAliasesFile());
            BufferedWriter bw = new BufferedWriter(fw);
            String oldClassName = "net.sourceforge.squirrel_sql.fw.sql.SQLAlias";
            String newClassName = SQLAlias.class.getName();
            Object line = br.readLine();
            while (null != line) {
                int ix = ((String)line).indexOf(oldClassName);
                if (-1 != ix) {
                    line = ((String)line).substring(0, ix) + newClassName + ((String)line).substring(ix + oldClassName.length(), ((String)line).length());
                }
                bw.write((String)line + "\n");
                line = br.readLine();
            }
            bw.flush();
            fw.flush();
            bw.close();
            fw.close();
            br.close();
            fr.close();
            return null;
        }
        catch (Exception e) {
            return "Conversion of Aliases file failed: Could not write new Aliases file named \n" + appFiles.getDatabaseAliasesFile().getPath() + "\nYou can not start this new version of SQuirreL using your existing Aliases.\nYou may either continue to use your former SQuirreL version or remove file\n" + appFiles.getDatabaseAliasesFile_before_version_2_3().getPath() + "\nfor your first start of this SQuirreL version. SQuirreL will then try to create an empty Alias file named\n" + appFiles.getDatabaseAliasesFile().getPath() + "\nPlease contact us about this problem. Send a mail to squirrel-sql-users@lists.sourceforge.net.";
        }
    }
}

