/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client;

import java.awt.Component;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import javax.swing.UIManager;
import net.sourceforge.squirrel_sql.fw.gui.FontInfo;

public class FontInfoStore {
    private FontInfo _defaultFontInfo = new FontInfo();
    private FontInfo _statusBarFontInfo;
    private PropertyChangeSupport _changeSupport;
    ReferenceQueue<Component> _discardQueue = new ReferenceQueue();

    public FontInfoStore() {
        PropertyChangeListener listener = evt -> {
            switch (evt.getPropertyName()) {
                case "lookAndFeel": {
                    this.updateDefaultFontInfo();
                    break;
                }
                case "Label.font": {
                    this.updateDefaultFontInfo();
                }
            }
        };
        UIManager.addPropertyChangeListener(listener);
        UIManager.getDefaults().addPropertyChangeListener(listener);
        this.updateDefaultFontInfo();
    }

    private void updateDefaultFontInfo() {
        Font tmp = (Font)UIManager.get("Label.font");
        if (tmp != null) {
            FontInfo oldValue = this.getStatusBarFontInfo();
            double smallerSize = (double)tmp.getSize() * 0.85;
            Font font = tmp.deriveFont(1, Math.max((float)Math.round(smallerSize), 10.0f));
            this._defaultFontInfo = new FontInfo(font);
            if (this._changeSupport != null) {
                this._changeSupport.fireIndexedPropertyChange("statusBarFontInfo", 0, oldValue, this.getStatusBarFontInfo());
            }
        }
    }

    public FontInfo getStatusBarFontInfo() {
        return this._statusBarFontInfo != null ? this._statusBarFontInfo : this._defaultFontInfo;
    }

    public void setStatusBarFontInfo(FontInfo fi) {
        FontInfo oldValue = this.getStatusBarFontInfo();
        this._statusBarFontInfo = fi;
        if (this._changeSupport != null) {
            this._changeSupport.firePropertyChange("statusBarFontInfo", oldValue, this.getStatusBarFontInfo());
        }
    }

    public void setUpStatusBarFont(Component comp) {
        comp.setFont(this.getStatusBarFontInfo().createFont());
        this.addPropertyChangeListener(new StatusBarFontListener(comp));
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this._changeSupport == null) {
            this._changeSupport = new PropertyChangeSupport(this);
        }
        this._changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this._changeSupport == null) {
            return;
        }
        this._changeSupport.removePropertyChangeListener(listener);
    }

    private class StatusBarFontListener
    extends WeakReference<Component>
    implements PropertyChangeListener {
        StatusBarFontListener(Component comp) {
            super(comp, FontInfoStore.this._discardQueue);
            this.removeDiscarded();
        }

        private void removeDiscarded() {
            StatusBarFontListener ref = (StatusBarFontListener)FontInfoStore.this._discardQueue.poll();
            while (ref != null) {
                FontInfoStore.this.removePropertyChangeListener(ref);
                ref = (StatusBarFontListener)FontInfoStore.this._discardQueue.poll();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Component c = (Component)this.get();
            if (c == null) {
                FontInfoStore.this.removePropertyChangeListener(this);
                return;
            }
            if ("statusBarFontInfo".equals(evt.getPropertyName())) {
                c.setFont(FontInfoStore.this.getStatusBarFontInfo().createFont());
            }
        }
    }
}

