/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.Application;
import net.sourceforge.squirrel_sql.client.ApplicationArguments;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.OutOfMemoryErrorHandler;
import net.sourceforge.squirrel_sql.client.Version;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.fw.util.log.SquirrelLoggerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.SystemOutToLog;

public class Main {
    private static ILogger s_log;
    private static Application application;

    private Main() {
    }

    public static void main(String[] args) throws IOException {
        if (ApplicationArguments.initialize(args)) {
            ApplicationArguments appArgs;
            if (!Version.supportsUsedJDK()) {
                JOptionPane.showMessageDialog(null, Version.getUnsupportedJDKMessage());
                System.exit(-1);
            }
            if ((appArgs = ApplicationArguments.getInstance()).getShowHelp()) {
                appArgs.printHelp();
            } else {
                Main.startApp();
            }
        }
    }

    private static void startApp() {
        LoggerController.registerLoggerFactory(new SquirrelLoggerFactory());
        s_log = LoggerController.createLogger(Main.class);
        System.setErr(new PrintStream(new SystemOutToLog(System.err)));
        System.setOut(new PrintStream(new SystemOutToLog(System.out)));
        EventQueue systemEventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        systemEventQueue.push(new EventQueue(){
            OutOfMemoryErrorHandler oumErrorHandler = new OutOfMemoryErrorHandler();

            @Override
            protected void dispatchEvent(AWTEvent event) {
                try {
                    super.dispatchEvent(event);
                }
                catch (Throwable e) {
                    Main.doLogging(event, e);
                    Main.doOutOfMemory(event, e, this.oumErrorHandler);
                }
            }
        });
        SwingUtilities.invokeLater(() -> Main.doApplicationStartup());
    }

    private static void doApplicationStartup() {
        try {
            application = new Application();
            application.startup();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private static void doLogging(AWTEvent event, Throwable t) {
        if (s_log.isDebugEnabled()) {
            t.printStackTrace();
        }
        s_log.error("Exception occurred dispatching Event " + event, t);
    }

    private static void doOutOfMemory(AWTEvent event, Throwable e, OutOfMemoryErrorHandler oumErrorHandler) {
        if (Utilities.getDeepestThrowable(e) instanceof OutOfMemoryError) {
            try {
                oumErrorHandler.setApplication(application);
                oumErrorHandler.handleOutOfMemoryError();
            }
            catch (Throwable t) {
                Main.doLogging(event, t);
            }
        }
    }

    public static IApplication getApplication() {
        return application;
    }

    public static void setApplication(Application application) {
        Main.application = application;
    }
}

