/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client;

import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.IShutdownTimer;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ShutdownTimer
implements Runnable,
IShutdownTimer {
    private static ILogger s_log = LoggerController.createLogger(ShutdownTimer.class);
    private int _shutdownSeconds;
    private IApplication _app;

    @Override
    public void start() {
        Thread t = new Thread((Runnable)this, "ShutdownTimerThread");
        t.start();
    }

    @Override
    public void run() {
        try {
            Thread.sleep(this._shutdownSeconds * 1000);
        }
        catch (InterruptedException e) {
            s_log.error("Shutdown timer thread was interrupted unexpectedly: " + e.getMessage(), e);
        }
        s_log.info("ShutdownTimer is shutting down the application");
        System.exit(this._app.shutdown(false) ? 0 : 1);
    }

    @Override
    public void setShutdownSeconds(int shutdownSeconds) {
        this._shutdownSeconds = shutdownSeconds;
    }

    @Override
    public void setApplication(IApplication app) {
        this._app = app;
    }
}

