/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.action;

import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.ISessionWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.IWidget;
import net.sourceforge.squirrel_sql.client.gui.session.ObjectTreeInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SQLInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SessionInternalFrame;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.filemanager.FileHandler;
import net.sourceforge.squirrel_sql.client.session.filemanager.IFileEditorAPI;
import net.sourceforge.squirrel_sql.client.session.mainpanel.IMainPanelTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreePanel;

public class ActionUpdateHelper {
    private ISession _session;
    private ISQLPanelAPI _sqlPanelAPI;
    private IFileEditorAPI _fileEditorAPI;
    private ObjectTreePanel _objectTreePanel;
    private IMainPanelTab _selectedMainTab;

    public ActionUpdateHelper(IWidget frame) {
        boolean isSQLFrame = frame instanceof SQLInternalFrame;
        boolean isTreeFrame = frame instanceof ObjectTreeInternalFrame;
        boolean isSessionInternalFrame = frame instanceof SessionInternalFrame;
        if (frame instanceof ISessionWidget) {
            this._session = ((ISessionWidget)frame).getSession();
        }
        if (isSQLFrame) {
            this._sqlPanelAPI = ((SQLInternalFrame)frame).getSQLPanel().getSQLPanelAPI();
        }
        if (isTreeFrame) {
            this._objectTreePanel = ((ObjectTreeInternalFrame)frame).getObjectTreePanel();
        }
        if (isSessionInternalFrame) {
            this._selectedMainTab = this._session.getSelectedMainTab();
        }
        if (isSessionInternalFrame) {
            SessionInternalFrame sif = (SessionInternalFrame)frame;
            this._sqlPanelAPI = sif.getSessionPanel().isAnSQLTabSelected() ? sif.getSessionPanel().getSelectedSQLPanel().getSQLPanelAPI() : null;
            this._objectTreePanel = sif.getSessionPanel().isObjectTreeTabSelected() ? ((SessionInternalFrame)frame).getSessionPanel().getObjectTreePanel() : null;
            this._fileEditorAPI = sif.getActiveIFileEditorAPIOrNull();
        }
        if (null != this._sqlPanelAPI && this._sqlPanelAPI.getSQLPanelSplitter().isSplit()) {
            this._objectTreePanel = this._sqlPanelAPI.getSQLPanelSplitter().getObjectTreePanel();
        }
    }

    public ISession getSession() {
        return this._session;
    }

    public ISQLPanelAPI getSQLPanelAPI() {
        return this._sqlPanelAPI;
    }

    public IObjectTreeAPI getObjectTreePanel() {
        return this._objectTreePanel;
    }

    public IMainPanelTab getSelectedMainTab() {
        return this._selectedMainTab;
    }

    public FileHandler getFileHandler() {
        if (null != this._sqlPanelAPI) {
            return this._sqlPanelAPI.getFileHandler();
        }
        if (null != this._fileEditorAPI) {
            return this._fileEditorAPI.getFileHandler();
        }
        return null;
    }
}

