/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.EventListenerList;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.swing.text.html.StyleSheet;
import net.sourceforge.squirrel_sql.client.gui.HtmlViewerPanelListenerEvent;
import net.sourceforge.squirrel_sql.client.gui.IHtmlViewerPanelListener;
import net.sourceforge.squirrel_sql.fw.gui.CursorChanger;
import net.sourceforge.squirrel_sql.fw.gui.stdtextpopup.TextPopupMenu;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class HtmlViewerPanel
extends JPanel {
    private static final ILogger s_log = LoggerController.createLogger(HtmlViewerPanel.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(HtmlViewerPanel.class);
    private final JEditorPane _contentsTxt = new JEditorPane(){

        @Override
        public void paint(Graphics g) {
            if (g instanceof Graphics2D) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                super.paint(g2);
                g2.dispose();
            } else {
                super.paint(g);
            }
        }
    };
    private JScrollPane _contentsScrollPane;
    private URL _homeURL;
    private URL _currentURL;
    private final List<URL> _history = new LinkedList<URL>();
    private int _historyIndex = -1;
    private EventListenerList _listenerList = new EventListenerList();
    private StyleSheet _styleSheet;

    public HtmlViewerPanel(URL url) {
        this.createGUI();
        this.setHomeURL(url);
        this.setURL(url);
    }

    public URL getURL() {
        return this._currentURL;
    }

    public URL getHomeURL() {
        return this._homeURL;
    }

    public void setHomeURL(URL homeURL) {
        this._homeURL = homeURL;
        this.fireHomeURLChanged();
    }

    public void setStyleURL(String urlSpec) {
        if (urlSpec == null) {
            this._styleSheet = null;
            return;
        }
        try {
            URL baseURL = this.getHomeURL();
            URL styleURL = baseURL != null ? baseURL.toURI().resolve(urlSpec).toURL() : new URL(urlSpec);
            this._styleSheet = new StyleSheet();
            try (InputStream in = styleURL.openStream();
                 InputStreamReader rules = new InputStreamReader(in);){
                this._styleSheet.loadRules(rules, styleURL);
            }
        }
        catch (IOException | URISyntaxException e) {
            s_log.warn("Problem loading style sheet: " + urlSpec, e);
        }
    }

    public int getFontSize() {
        return this._contentsTxt.getFont().getSize();
    }

    public void setFontSize(int size) {
        this._contentsTxt.setFont(this._contentsTxt.getFont().deriveFont((float)size));
    }

    public void addListener(IHtmlViewerPanelListener lis) {
        this._listenerList.add(IHtmlViewerPanelListener.class, lis);
    }

    void removeListener(IHtmlViewerPanelListener lis) {
        this._listenerList.remove(IHtmlViewerPanelListener.class, lis);
    }

    public synchronized void gotoURL(URL url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("URL == null");
        }
        if (!url.equals(this._currentURL)) {
            ListIterator<URL> it = this._history.listIterator(this._historyIndex + 1);
            while (it.hasNext()) {
                it.next();
                it.remove();
            }
            this._history.add(url);
            this._historyIndex = this._history.size() - 1;
            this._contentsTxt.setPage(url);
            this._currentURL = url;
            this.fireURLChanged();
        } else if (url.getRef() != null) {
            this._contentsTxt.setPage(url);
        }
    }

    public synchronized void goBack() {
        if (this._historyIndex > 0 && this._historyIndex < this._history.size()) {
            this.displayURL(this._history.get(--this._historyIndex));
        }
    }

    public synchronized void goForward() {
        if (this._historyIndex > -1 && this._historyIndex < this._history.size() - 1) {
            this.displayURL(this._history.get(++this._historyIndex));
        }
    }

    public synchronized void goHome() {
        this._historyIndex = 0;
        this.displayURL(this._homeURL);
    }

    public void refreshPage() {
        this._contentsScrollPane.putClientProperty("savedScrollPosition", this._contentsScrollPane.getViewport().getViewPosition());
        this._contentsTxt.getDocument().putProperty("stream", null);
        this.displayURL(this._currentURL);
    }

    private synchronized void setURL(URL url) {
        if (url != null) {
            CursorChanger cursorChg = new CursorChanger(this);
            cursorChg.show();
            try {
                this.displayURL(url);
                this._history.add(url);
                this._historyIndex = 0;
            }
            finally {
                cursorChg.restore();
            }
        }
    }

    private void displayURL(URL url) {
        if (url != null) {
            try {
                this._contentsTxt.setPage(url);
                this._currentURL = url;
                this.fireURLChanged();
            }
            catch (Exception ex) {
                s_log.error(s_stringMgr.getString("HtmlViewerPanel.error.displayurl"), ex);
            }
        }
    }

    private void fireURLChanged() {
        Object[] listeners = this._listenerList.getListenerList();
        HtmlViewerPanelListenerEvent evt = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IHtmlViewerPanelListener.class) continue;
            if (evt == null) {
                evt = new HtmlViewerPanelListenerEvent(this);
            }
            ((IHtmlViewerPanelListener)listeners[i + 1]).currentURLHasChanged(evt);
        }
    }

    private void fireHomeURLChanged() {
        Object[] listeners = this._listenerList.getListenerList();
        HtmlViewerPanelListenerEvent evt = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IHtmlViewerPanelListener.class) continue;
            if (evt == null) {
                evt = new HtmlViewerPanelListenerEvent(this);
            }
            ((IHtmlViewerPanelListener)listeners[i + 1]).homeURLHasChanged(evt);
        }
    }

    private void createGUI() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createMainPanel(), "Center");
    }

    private JPanel createMainPanel() {
        Runnable keepEditableColors = () -> {
            this._contentsTxt.setEditable(true);
            Color bg = this._contentsTxt.getBackground();
            Color fg = this._contentsTxt.getForeground();
            this._contentsTxt.setEditable(false);
            this._contentsTxt.setBackground(bg);
            this._contentsTxt.setForeground(fg);
        };
        keepEditableColors.run();
        this._contentsTxt.addPropertyChangeListener("UI", evt -> keepEditableColors.run());
        this._contentsTxt.putClientProperty("JEditorPane.honorDisplayProperties", true);
        this._contentsTxt.setContentType("text/html");
        this._contentsTxt.setEditorKitForContentType("text/html", new HTMLEditorKit(){

            @Override
            public Document createDefaultDocument() {
                HTMLDocument doc = (HTMLDocument)super.createDefaultDocument();
                if (HtmlViewerPanel.this._styleSheet != null) {
                    doc.getStyleSheet().addStyleSheet(HtmlViewerPanel.this._styleSheet);
                    doc.getStyleSheet().addRule("body { font-size: " + HtmlViewerPanel.this.getFontSize() + "}");
                }
                return doc;
            }
        });
        this._contentsTxt.addPropertyChangeListener("font", evt -> {
            Object newFont = evt.getNewValue();
            if (newFont instanceof Font) {
                Font oldFont = (Font)evt.getOldValue();
                int fontSize = ((Font)newFont).getSize();
                this.firePropertyChange("fontSize", oldFont == null ? -1 : oldFont.getSize(), fontSize);
                Document document = this._contentsTxt.getDocument();
                if (document instanceof HTMLDocument) {
                    ((HTMLDocument)document).getStyleSheet().addRule("body { font-size: " + fontSize + " }");
                }
            }
        });
        this._contentsTxt.addPropertyChangeListener("page", evt -> {
            Object pos = this._contentsScrollPane.getClientProperty("savedScrollPosition");
            if (pos instanceof Point) {
                this._contentsScrollPane.getViewport().setViewPosition((Point)pos);
                this._contentsScrollPane.putClientProperty("savedScrollPosition", null);
            }
        });
        final TextPopupMenu pop = new TextPopupMenu();
        pop.setTextComponent(this._contentsTxt);
        this._contentsTxt.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    pop.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    pop.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }
        });
        JPanel pnl = new JPanel(new BorderLayout());
        this._contentsTxt.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 0));
        this._contentsTxt.addHyperlinkListener(this.createHyperLinkListener());
        this._contentsScrollPane = new JScrollPane(this._contentsTxt, 22, 30);
        pnl.add((Component)this._contentsScrollPane, "Center");
        this.initKeyBindings();
        return pnl;
    }

    private void initKeyBindings() {
        InputMap scrollKeys = new InputMap();
        scrollKeys.put(KeyStroke.getKeyStroke(32, 0), "scrollDown");
        scrollKeys.put(KeyStroke.getKeyStroke(32, 64), "scrollUp");
        scrollKeys.put(KeyStroke.getKeyStroke(34, 0), "scrollDown");
        scrollKeys.put(KeyStroke.getKeyStroke(33, 0), "scrollUp");
        scrollKeys.put(KeyStroke.getKeyStroke(36, 0), "scrollHome");
        scrollKeys.put(KeyStroke.getKeyStroke(35, 0), "scrollEnd");
        scrollKeys.put(KeyStroke.getKeyStroke(40, 0), "unitScrollDown");
        scrollKeys.put(KeyStroke.getKeyStroke(38, 0), "unitScrollUp");
        scrollKeys.put(KeyStroke.getKeyStroke(39, 0), "unitScrollRight");
        scrollKeys.put(KeyStroke.getKeyStroke(37, 0), "unitScrollLeft");
        InputMap scrollInput = this._contentsScrollPane.getInputMap(1);
        scrollKeys.setParent(scrollInput.getParent());
        scrollInput.setParent(scrollKeys);
        InputMap editKeys = this._contentsTxt.getInputMap();
        for (KeyStroke keyStroke : scrollKeys.keys()) {
            HtmlViewerPanel.removeKey(editKeys, keyStroke);
        }
    }

    private static void removeKey(InputMap inputMap, KeyStroke keyStroke) {
        Object command = inputMap.get(keyStroke);
        if (command == null) {
            return;
        }
        for (InputMap current = inputMap; current != null; current = current.getParent()) {
            current.remove(keyStroke);
        }
    }

    private HyperlinkListener createHyperLinkListener() {
        return new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    if (e instanceof HTMLFrameHyperlinkEvent) {
                        ((HTMLDocument)HtmlViewerPanel.this._contentsTxt.getDocument()).processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)e);
                    } else {
                        try {
                            HtmlViewerPanel.this.gotoURL(e.getURL());
                        }
                        catch (IOException ex) {
                            s_log.error(s_stringMgr.getString("HtmlViewerPanel.error.processhyperlink"), ex);
                        }
                    }
                }
            }
        };
    }
}

