/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.gui.HtmlViewerPanel;
import net.sourceforge.squirrel_sql.fw.gui.ToolBar;

public class HtmlViewerPanelToolBar
extends ToolBar {
    private final IApplication _app;
    private final HtmlViewerPanel _pnl;

    public HtmlViewerPanelToolBar(IApplication app, HtmlViewerPanel pnl) {
        if (app == null) {
            throw new IllegalArgumentException("IApplication == null");
        }
        if (pnl == null) {
            throw new IllegalArgumentException("HtmlViewerPanel == null");
        }
        this._app = app;
        this._pnl = pnl;
        this.setUseRolloverButtons(true);
        this.setFloatable(false);
        this.add(new HomeAction(this._app));
        this.add(new BackAction(this._app));
        this.add(new ForwardAction(this._app));
        this.add(new RefreshAction(this._app));
        this.mapInputAction(new SmallerFontAction());
        this.mapInputAction(new BiggerFontAction());
    }

    private final class SmallerFontAction
    extends AbstractAction {
        SmallerFontAction() {
            super("Decrease Text Size");
            super.putValue("AcceleratorKey", KeyStroke.getKeyStroke(45, 128));
            HtmlViewerPanelToolBar.this._pnl.addPropertyChangeListener("fontSize", evt -> this.updateEnabled());
            this.updateEnabled();
        }

        void updateEnabled() {
            super.setEnabled(HtmlViewerPanelToolBar.this._pnl.getFontSize() > 11);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            HtmlViewerPanelToolBar.this._pnl.setFontSize(HtmlViewerPanelToolBar.this._pnl.getFontSize() - 1);
        }
    }

    private final class BiggerFontAction
    extends AbstractAction {
        BiggerFontAction() {
            super("Increase Text Size");
            super.putValue("AcceleratorKey", KeyStroke.getKeyStroke(61, 128));
            HtmlViewerPanelToolBar.this._pnl.addPropertyChangeListener("fontSize", evt -> this.updateEnabled());
            this.updateEnabled();
        }

        void updateEnabled() {
            super.setEnabled(HtmlViewerPanelToolBar.this._pnl.getFontSize() < 24);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            HtmlViewerPanelToolBar.this._pnl.setFontSize(HtmlViewerPanelToolBar.this._pnl.getFontSize() + 1);
        }
    }

    private final class HomeAction
    extends SquirrelAction {
        public HomeAction(IApplication app) {
            super(app);
            if (app == null) {
                throw new IllegalArgumentException("Null IApplication passed");
            }
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            HtmlViewerPanelToolBar.this._pnl.goHome();
        }
    }

    private final class RefreshAction
    extends SquirrelAction {
        public RefreshAction(IApplication app) {
            super(app);
            if (app == null) {
                throw new IllegalArgumentException("Null IApplication passed");
            }
            super.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, 128));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            HtmlViewerPanelToolBar.this._pnl.refreshPage();
        }
    }

    private final class ForwardAction
    extends SquirrelAction {
        public ForwardAction(IApplication app) {
            super(app);
            if (app == null) {
                throw new IllegalArgumentException("Null IApplication passed");
            }
            super.putValue("AcceleratorKey", KeyStroke.getKeyStroke(39, 512));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            HtmlViewerPanelToolBar.this._pnl.goForward();
        }
    }

    private final class BackAction
    extends SquirrelAction {
        public BackAction(IApplication app) {
            super(app);
            if (app == null) {
                throw new IllegalArgumentException("Null IApplication passed");
            }
            super.putValue("AcceleratorKey", KeyStroke.getKeyStroke(37, 512));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            HtmlViewerPanelToolBar.this._pnl.goBack();
        }
    }
}

