/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui;

import java.text.DateFormat;
import java.util.Date;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

class MemorySessionInfo
implements Comparable<MemorySessionInfo> {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(MemorySessionInfo.class);
    IIdentifier sessionId;
    String aliasName;
    Date created = new Date();
    Date closed;
    Date finalized;

    MemorySessionInfo(IIdentifier sessionId, String aliasName) {
        this.sessionId = sessionId;
        this.aliasName = aliasName;
    }

    public String toString() {
        DateFormat df = DateFormat.getInstance();
        Object[] params = new Object[]{this.sessionId, this.aliasName, df.format(this.created), null == this.closed ? "" : df.format(this.closed), null == this.finalized ? "" : df.format(this.finalized)};
        if (null != this.closed && null == this.finalized) {
            return s_stringMgr.getString("MemoryPanel.sessionInfo.toString1", params);
        }
        if (null == this.closed) {
            return s_stringMgr.getString("MemoryPanel.sessionInfo.toString2", params);
        }
        if (null != this.finalized) {
            return s_stringMgr.getString("MemoryPanel.sessionInfo.toString3", params);
        }
        throw new IllegalStateException("Unknown Session state");
    }

    @Override
    public int compareTo(MemorySessionInfo other) {
        return Integer.valueOf(this.sessionId.toString()).compareTo(Integer.valueOf(other.sessionId.toString()));
    }
}

