/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.ProgressCallBack;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ProgressCallBackDialog
extends JDialog
implements ProgressCallBack {
    public static final ILogger s_log = LoggerController.createLogger(ProgressCallBackDialog.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ProgressCallBackDialog.class);
    private int itemCount = 0;
    private JProgressBar progressBar = null;
    private JLabel statusLabel = null;
    private String _loadingPrefix = i18n.DEFAULT_LOADING_PREFIX;

    public ProgressCallBackDialog(Dialog owner, String title, int totalItems) {
        super(owner, title);
        this.init(totalItems);
    }

    public ProgressCallBackDialog(Frame owner, String title, int totalItems) {
        super(owner, title);
        this.setLocationRelativeTo(owner);
        this.init(totalItems);
    }

    @Override
    public void setTotalItems(int totalItems) {
        this.itemCount = totalItems;
        this.progressBar.setMaximum(totalItems);
    }

    @Override
    public void setLoadingPrefix(String loadingPrefix) {
        if (loadingPrefix != null) {
            this._loadingPrefix = loadingPrefix;
        }
    }

    @Override
    public void currentlyLoading(String simpleName) {
        final StringBuilder statusText = new StringBuilder();
        statusText.append(this._loadingPrefix);
        statusText.append(" ");
        statusText.append(simpleName);
        try {
            GUIUtils.processOnSwingEventThread(new Runnable(){

                @Override
                public void run() {
                    ProgressCallBackDialog.this.statusLabel.setText(statusText.toString());
                    ProgressCallBackDialog.this.progressBar.setValue(ProgressCallBackDialog.this.progressBar.getValue() + 1);
                    if (ProgressCallBackDialog.this.finishedLoading()) {
                        ProgressCallBackDialog.this.setVisible(false);
                        return;
                    }
                }
            });
        }
        catch (Exception e) {
            s_log.error("Unexpected exception: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean finishedLoading() {
        return this.progressBar.getValue() == this.itemCount;
    }

    @Override
    public void dispose() {
        GUIUtils.processOnSwingEventThread(new Runnable(){

            @Override
            public void run() {
                ProgressCallBackDialog.this.callDisposeFromSuperClass();
            }
        });
    }

    private void callDisposeFromSuperClass() {
        super.dispose();
    }

    @Override
    public void setVisible(final boolean b) {
        GUIUtils.processOnSwingEventThread(new Runnable(){

            @Override
            public void run() {
                ProgressCallBackDialog.this.callSetVisibleFromSuperClass(b);
            }
        });
    }

    private void callSetVisibleFromSuperClass(boolean b) {
        super.setVisible(b);
    }

    private void init(int totalItems) {
        this.itemCount = totalItems;
        Window owner = super.getOwner();
        ProgressCallBackDialog dialog = this;
        this.createGUI();
        this.setLocationRelativeTo(owner);
        dialog.setVisible(true);
    }

    private void createGUI() {
        JPanel dialogPanel = new JPanel(new GridBagLayout());
        dialogPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.anchor = 17;
        this.statusLabel = new JLabel(i18n.INITIAL_LOADING_PREFIX);
        dialogPanel.add((Component)this.statusLabel, c);
        this.progressBar = new JProgressBar(0, this.itemCount);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(0, 0, 10, 0);
        c.weightx = 1.0;
        dialogPanel.add((Component)this.progressBar, c);
        super.getContentPane().add(dialogPanel);
        super.pack();
        super.setSize(new Dimension(400, 100));
    }

    static interface i18n {
        public static final String DEFAULT_LOADING_PREFIX = s_stringMgr.getString("ProgressCallBackDialog.defaultLoadingPrefix");
        public static final String INITIAL_LOADING_PREFIX = s_stringMgr.getString("ProgressCallBackDialog.initialLoadingPrefix");
    }
}

